#if !defined (ACE_HAS_THREADS)
INLINE thread_t 
ACE_Thread::self (void)
{
  ACE_TRACE ("ACE_Thread::self");
  return 1;
}

INLINE void
ACE_Thread::self (hthread_t &)
{
  ACE_TRACE ("ACE_Thread::self");
}

INLINE void
ACE_Thread::exit (void *status)
{
  ACE_TRACE ("ACE_Thread::exit");
  ACE_OS::exit (long (status));
}
#else

// Allocates a <keyp> that is used to identify data that is specific
// to each thread in the process.  The key is global to all threads in
// the process.

INLINE int
ACE_Thread::keycreate (thread_key_t *keyp,
		       void (*destructor)(void *value))
{
  ACE_TRACE ("ACE_Thread::keycreate");
  return ACE_OS::thr_keycreate (keyp, destructor);
}

// Bind value to the thread-specific data key, <key>, for the calling
// thread.

INLINE int 
ACE_Thread::setspecific (thread_key_t key, void *value)
{
  ACE_TRACE ("ACE_Thread::setspecific");
  return ACE_OS::thr_setspecific (key, value);
}

// Stores the current value bound to <key> for the calling thread
// into the location pointed to by <valuep>.

INLINE int 
ACE_Thread::getspecific (thread_key_t key, void **valuep)
{
  ACE_TRACE ("ACE_Thread::getspecific");
  return ACE_OS::thr_getspecific (key, valuep);
}

INLINE thread_t 
ACE_Thread::self (void)
{
  ACE_TRACE ("ACE_Thread::self");
  return ACE_OS::thr_self ();
}

INLINE void 
ACE_Thread::exit (void *status)
{
  ACE_TRACE ("ACE_Thread::exit");
  ACE_OS::thr_exit (status);
}

INLINE void
ACE_Thread::yield (void)
{
  ACE_TRACE ("ACE_Thread::yield");
  ACE_OS::thr_yield ();
}

INLINE int 
ACE_Thread::spawn (ACE_THR_FUNC func, 
		   void *arg, 
		   long flags, 
		   thread_t *t_id, 
		   hthread_t *t_handle,
		   u_int priority,
		   void *stack, 
		   size_t stack_size)
{
  ACE_TRACE ("ACE_Thread::spawn");
  return ACE_OS::thr_create (func, arg, flags, t_id, t_handle, 
			     priority, stack, stack_size);
}

INLINE int 
ACE_Thread::spawn_n (size_t n, 
		     ACE_THR_FUNC func, 
		     void *arg, 
		     long flags, 
		     u_int priority,
		     void *stack, 
		     size_t stack_size)
{
  ACE_TRACE ("ACE_Thread::spawn_n");
  thread_t t_id;
  size_t i;

  for (i = 0; i < n; i++)
    // Bail out if error occurs.
    if (ACE_OS::thr_create (func, arg, flags, &t_id, 0, 
			    priority, stack, stack_size) != 0)
      break;

  return i;
}

INLINE int 
ACE_Thread::spawn_n (thread_t thread_ids[],
		     size_t n, 
		     ACE_THR_FUNC func, 
		     void *arg, 
		     long flags, 
		     u_int priority,
		     void *stack, 
		     size_t stack_size)
{
  ACE_TRACE ("ACE_Thread::spawn_n");
  thread_t t_id;
  size_t i;

  for (i = 0; i < n; i++)
    // Bail out if error occurs.
    if (ACE_OS::thr_create (func, arg, flags, &t_id, 0, 
			    priority, stack, stack_size) == 0)
      thread_ids[i] = t_id;
    else
      break;

  return i;
}

INLINE int 
ACE_Thread::resume (hthread_t t_id)
{
  ACE_TRACE ("ACE_Thread::resume");
  return ACE_OS::thr_continue (t_id);
}

INLINE int 
ACE_Thread::suspend (hthread_t t_id)
{
  ACE_TRACE ("ACE_Thread::suspend");
  return ACE_OS::thr_suspend (t_id);
}

INLINE int 
ACE_Thread::kill (thread_t t_id, int signum)
{
  ACE_TRACE ("ACE_Thread::kill");
  return ACE_OS::thr_kill (t_id, signum);
}

INLINE int 
ACE_Thread::join (thread_t wait_for, 
		  thread_t *departed, 
		  void **status)
{
  ACE_TRACE ("ACE_Thread::join");
  return ACE_OS::thr_join (wait_for, departed, status);
}

INLINE int 
ACE_Thread::join (hthread_t wait_for,
		  void **status)
{
  ACE_TRACE ("ACE_Thread::join");
  return ACE_OS::thr_join (wait_for, status);
}

INLINE int 
ACE_Thread::getconcurrency (void)
{
  ACE_TRACE ("ACE_Thread::getconcurrency");
  return ACE_OS::thr_getconcurrency ();
}

INLINE int 
ACE_Thread::setconcurrency (int new_level)
{
  ACE_TRACE ("ACE_Thread::setconcurrency");
  return ACE_OS::thr_setconcurrency (new_level);
}

INLINE int 
ACE_Thread::sigsetmask (int how, 
			const sigset_t *set, 
			sigset_t *oset)
{
  ACE_TRACE ("ACE_Thread::sigsetmask");
  return ACE_OS::thr_sigsetmask (how, set, oset);
}

INLINE int
ACE_Thread::disablecancel (struct cancel_state *old_state)
{
  ACE_TRACE ("ACE_Thread::disablecancel");
  int old_cstate;
  int retval;
  if ((retval = ACE_OS::thr_setcancelstate (THR_CANCEL_DISABLE,
					    &old_cstate)) == 0)
  if (old_state != 0)
    {
      ACE_OS::memset (old_state, 0, sizeof(old_state));
      old_state->cancelstate = old_cstate;
    }

  return retval;
}

INLINE int
ACE_Thread::enablecancel (struct cancel_state *old_state, 
			  int flag)
{
  ACE_TRACE ("ACE_Thread::enablecancel");
  int old_cstate;
  int old_ctype;
  int retval;

  retval = ACE_OS::thr_setcancelstate (THR_CANCEL_ENABLE, &old_cstate);

  if (retval != 0)
    return retval;

  retval = ACE_OS::thr_setcanceltype (flag, &old_ctype);

  if (retval != 0)
    return retval;

  if (old_state != 0)
    {
      old_state->cancelstate = old_cstate;
      old_state->canceltype = old_ctype;
    }

  return 0;
}

INLINE int
ACE_Thread::setcancelstate (struct cancel_state &new_state,
			    struct cancel_state *old_state)
{
  ACE_TRACE ("ACE_Thread::setcancelstate");
  int old_cstate;
  int old_ctype;

  if (new_state.cancelstate != 0
      && ACE_OS::thr_setcancelstate (new_state.cancelstate, &old_cstate) == 0)
    return -1;

  if (new_state.canceltype != 0 
      && ACE_OS::thr_setcanceltype (new_state.canceltype, &old_ctype) == 0)
    {
      int o_cstate;
      ACE_OS::thr_setcancelstate (old_cstate, &o_cstate);
      return -1;
    }

  if (old_state != 0)
    {
      old_state->cancelstate = old_cstate;
      old_state->canceltype = old_ctype;
    }

  return 0;
}

INLINE int
ACE_Thread::cancel (thread_t t_id)
{
  ACE_TRACE ("ACE_Thread::cancel");

  return ACE_OS::thr_cancel (t_id);
}

INLINE void
ACE_Thread::testcancel (void)
{
  ACE_TRACE ("ACE_Thread::testcancel");

  ACE_OS::thr_testcancel ();
}

INLINE void
ACE_Thread::self (hthread_t &t_id)
{
  ACE_TRACE ("ACE_Thread::self");
  ACE_OS::thr_self (t_id);
}

#endif /* !defined (ACE_HAS_THREADS) */
