/* -*- C++ -*- */

// ============================================================================
//
// = LIBRARY
//    ace
// 
// = FILENAME
//    Log_Priority.h
//
// = AUTHOR
//    Doug Schmidt 
// 
// ============================================================================

#if !defined (ACE_LM_PRIORITY_H)
#define ACE_LM_PRIORITY_H

/* The following data type indicates the relative priorities
   of the logging messages, from lowest to highest priority... */

enum ACE_Log_Priority
{
  // = Note, this first argument *must* start at 1! 

  LM_SHUTDOWN = 1, 
  // Shutdown the logger 

  LM_TRACE = 2,    
  // Messages indicating function-calling sequence 

  LM_DEBUG = 3,    
  // Messages that contain information normally of use only when debugging a program 

  LM_INFO = 4,	    
  // Informational messages 

  LM_NOTICE = 5,   
  // Conditions that are not error conditions, but that may require special handling 

  LM_WARNING = 6,  
  // Warning messages 

  LM_STARTUP = 7,  
  // Initialize the logger 

  LM_ERROR = 8,    
  // Errors 

  LM_CRITICAL = 9,	    
  // Critical conditions, such as hard device errors 

  LM_ALERT = 10,    
  // A condition that should be corrected immediately, such as a corrupted system database 

  LM_EMERGENCY = 11,   
  // A panic condition  This is normally broadcast to all users 

  LM_MAX = 12	    
  // Maximum logging priority + 1 
};

#endif /* ACE_LM_PRIORITY_H */
