//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Administration Class
//
//      Unix environment variable CMLOG_PORT changes
//      broadcasting destination port number
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogAdmin.h,v $
//   Revision 1.2  2001/07/25 14:24:39  chen
//   64 BIT Initial Port
//
//   Revision 1.1.1.1  1999/09/07 15:29:02  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:16:59  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_ADMIN_H
#define _CMLOG_ADMIN_H

#include <cdevData.h>
#include <cmlogMsg.h>
#include <cmlogCallback.h>
#include <cmlogSlist.h>
#include <cmlogStrHash.h>
#include <cmlogIntHash.h>

class cmlogAdminLocker;

class cmlogAdmin
{
public:
  // constructor
  cmlogAdmin             (void);
  // destructor
  ~cmlogAdmin            (void);

  // operations
  // return CMLOG_SUCCESS for success, CMLOG_ERROR for failure

  // connect to logging server
  int connect              (int connectionRetries = 3);
  int connected            (void) const;
  // disconnect
  int disconnect           (void);

  // send query information
  int getCallback          (char* attribute, 
			    cmlogBrCallback cbk, void* arg);

  // send shutdown request
  int shutdownServer       (void);

  // get file descriptor
  int getFd                (void) const;

  // pend io on this connection
  // Wait until outstanding events occur
  // seconds = 0.0 polling
  int pendIO               (double seconds);
  
  // wait on this connection forever
  int pendIO               (void);

protected:
  // handle low-level io: return 0: success, -1: bad io
  int            handle_input      (int fd);
  // handle low-level close when server is dead
  int            handle_close      (int fd);

  int    getCbkFromServer          (int status, char* attribute,
				    unsigned cbkid, cmlogPacket& packet);
  // process data come back from server
  int    processData               (cmlogPacket& packet);

private:
  // flag of connection
  int connected_;

  // udp socket to server port to find real tcp port
  int                udp_fd_;
  // tcp socket to server
  int                tcp_fd_;

  // server information
  unsigned short     serverPort_;          
  char*              serverHost_;

  // lock for browser object to prevent from this object being called 
  // recursively
  int                lock_;
  void               lock   (void);
  void               unlock (void);

  // get  id
  unsigned           qid_;
  // event id
  unsigned           evid_;
  
  // all get callback
  cmlogStrHash getCbkTable_;

  // friend class
  friend class cmlogAdminLocker;
  friend class cmlogAdminTagCallback;

  // deny access to copy and assignment operations
  cmlogAdmin (const cmlogAdmin& b);
  cmlogAdmin& operator = (const cmlogAdmin& b);
};

  // format of message send to the server in the cdevMessage
  // short      clientID;             -> client id from logging side (0)
  // unsigned   transIndex;           -> browser request index       
  // unsigned   cancelTransIndex;     -> not used
  // unsigned   localDataIndex;       -> not used
  // unsigned   foreignDataIndex;     -> evid
  //                                  -> only in the first one in the packet
  // unsigned   operationCode;        -> operation code
  // unsigned   deviceCount;          -> not used
  // char **    deviceList;           -> not used
  // char *     message;              -> "query", "get", "monitorOn", 
  //                                     "monitorOff"
  // cdevData * data;                 -> extra for query (outgoing)
  //                                  -> incoming result with status tag denote
  //                                  -> error condition (only first message)
  // cdevData * context;              -> not used
  // cdevData * tagMap;               -> not used
  // void *     arg                   -> cmlogIO pointer

class cmlogAdminLocker
{
public:
  cmlogAdminLocker  (cmlogAdmin* b);
  ~cmlogAdminLocker (void);

private:
  cmlogAdmin* b_;

  // denay access to copy and assignment operations
  cmlogAdminLocker (const cmlogAdminLocker& b);
  cmlogAdminLocker& operator = (const cmlogAdminLocker& b);
};
#endif
