//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Simple cmlog browser java test
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogBrowserQuery.java,v $
//   Revision 1.3  2000/03/17 19:16:35  chen
//   add multiple protocol support
//
//   Revision 1.2  2000/01/04 18:57:07  chen
//   Bug fixes for unsigned short port number
//
//   Revision 1.1  2000/01/04 14:26:08  chen
//   new implementation
//
//
//
//
import cmlog.*;

import java.io.*;
import java.net.*;
import java.text.*;
import java.util.*;

public class cmlogBrowserQuery implements BrowserQueryEventListener
{
    private String host_ = null;
    private int    port_ = 0;
    private static String format_ = "H:m@M/d/y";

    public cmlogBrowserQuery ()
    {
    }

    public void handleQueryEvent (BrowserEvent event)
    {
	cdevData data = null;
	cdevDataEntry de = null;
	String verb = event.verb;
	int    nmsgs = 0;
	int i;

	if (event.status == Config.CMLOG_SUCCESS || 
	    event.status == Config.CMLOG_INCOMPLETE) {
	    // get array of messages
	    cdevMessage[] msgs = event.packet.messages();
	    // get number of messages
	    nmsgs = event.packet.numberOfMessages();

	    for (i = 0; i < nmsgs; i++) {
		data = msgs[i].getData ();
		if (data != null) 
		    de = data.get (Config.TEXT_TAG);
		if (de != null) 
		    System.out.println (de.stringValue());
	    }
	}
	else if (event.status == Config.CMLOG_ERROR ||
		 event.status == Config.CMLOG_NOTFOUND) {
	    System.out.println ("Cannot find anything");
	}

    }

    public static void main (String[] args)
    {
	if (args.length < 5) {
	    System.err.println ("Usage: BrowserQuery host port start end protoversion(1 or 2) [debug]");
	    System.exit (-1);
	}

	cmlogBrowserQuery test = new cmlogBrowserQuery ();

	test.host_ = args[0];
	test.port_ = Integer.valueOf (args[1]).intValue();
	Config.PROTOCOL_MAJOR_VERSION = Integer.valueOf (args[4]).intValue();

	if (args.length > 5) {
	    String tstring = args[5];
	    if (tstring.compareTo ("debug") == 0)
		Config.debug = true;
	}
	
	// get start and end time
	SimpleDateFormat formatter = new SimpleDateFormat (format_);
	ParsePosition pos = new ParsePosition(0);
	Date start = formatter.parse (args[2], pos);
	if (start == null) {
	    System.err.println ("Start time syntax error");
	    System.exit (1);
	}

	pos.setIndex (0);
	Date end = formatter.parse (args[3], pos);
	if (end == null) {
	    System.err.println ("End time syntax error");
	    System.exit (1);
	}
	
	
	// create new Browser
	Browser br = new Browser ();
	try {
	    br.connect (test.host_, test.port_);
	}catch (UnknownHostException ue) {
	    System.err.println (ue);
	    System.exit (-1);
	}catch (IOException e) {
	    System.err.println (e);
	    System.exit (-1);
	}
	
	// create query data containing start and end time
	int      ssec = (int)(start.getTime()/1000);
	int      esec = (int)(end.getTime()/1000);

	cdevData qdata = new cdevData();
	qdata.insert (Config.START_TAG, ssec);
	qdata.insert (Config.END_TAG, esec);
	
	BrowserEvent oev = null;
	try {
	    oev = br.query (qdata, test);
	}catch (IllegalArgumentException e) {
	    System.err.println (e);
	    System.exit (-1);
	}catch (IOException ie) {
	    System.err.println (ie);
	    System.exit (-1);
	}
	
    }	
}
