//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Simple cmlog browser java test
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogBrowserMonitor.java,v $
//   Revision 1.3  2001/10/18 22:00:00  chen
//   fix minior API changes
//
//   Revision 1.2  2000/03/17 19:16:28  chen
//   add multiple protocol support
//
//   Revision 1.1  2000/01/04 14:26:08  chen
//   new implementation
//
//
//
import cmlog.*;

import java.io.*;
import java.net.*;
import java.util.*;

public class cmlogBrowserMonitor implements BrowserMonitorEventListener
{
    private String host_ = null;
    private int    port_ = 0;

    public cmlogBrowserMonitor ()
    {
    }

    public void handleMonitorEvent (BrowserEvent event)
    {
	cdevData data;
	int i;
	int nmsgs = 0;
	cdevDataEntry de;

	if (event.status == Config.CMLOG_SUCCESS) {
	    cdevMessage[] msgs = event.packet.messages();
	    nmsgs = event.packet.numberOfMessages ();
	    for (i = 0; i < nmsgs; i++) {
		data = msgs[i].getData ();
		de = data.get (Config.TEXT_TAG);
		System.out.println (de.stringValue());
		// data.asciiDump ();
	    }
	}
	else if (event.status == Config.CMLOG_CBK_FINISHED)
	    System.out.println ("Monitor finished\n");
    }

    public static void main (String[] args)
    {
	if (args.length < 3) {
	    System.err.println ("Usage: cmlogBrowserMonitor host port proto-version(1 or 2) [debug]");
	    System.exit (-1);
	}

	cmlogBrowserMonitor test = new cmlogBrowserMonitor ();

	test.host_ = args[0];
	test.port_ = Integer.valueOf (args[1]).intValue();
	Config.PROTOCOL_MAJOR_VERSION = Integer.valueOf (args[2]).intValue();

	if (args.length > 3) {
	    String tstring = args[3];
	    if (tstring.compareTo ("debug") == 0)
		Config.debug = true;
	}
	
	// create new cmlogBrowser
	Browser br = new Browser ();
	try {
	    br.connect (test.host_, test.port_);
	}catch (UnknownHostException ue) {
	    System.err.println (ue);
	    System.exit (-1);
	}catch (IOException e) {
	    System.err.println (e);
	    System.exit (-1);
	}
	
	if (br.addMonitorEventListener (null, test) == false) {
	    System.err.println ("Cannot register monitor event listener");
	    System.exit (-1);
	}

	// sleep 20 seconds before calling remove monitor
	try {
	    Thread.sleep (20000);
	}catch (InterruptedException e){
	}
	    

	System.out.println("<------------------------------------>");
	if (br.removeMonitorEventListener (null, test) == false) {
	    System.err.println ("Cannot Remove monitor event listener");
	    System.exit (-1);
	}
	System.out.println("<------------------------------------>");

	// sleep 20 seconds before calling remove monitor
	try {
	    Thread.sleep (2000);
	}catch (InterruptedException e){
	}

	try {
	    br.disconnect ();
	}catch (IOException e) {

	}

    }	
}
