/**************************************************************************
 * Copyright (c)   2001    Southeastern Universities Research Association,
 *                         Thomas Jefferson National Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
 **************************************************************************
 *
 * Description:
 *      Update menu button inside Options Menu
 *
 * Author:  
 *      Jie Chen
 *      Jefferson Lab HPC Group
 *
 * Revision History:
 *   $Log: Update.java,v $
 *   Revision 1.1  2001/10/18 18:45:43  chen
 *   First version of Jcmlog
 *
 *
 *
 */
package cmlog.gui;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

import cmlog.*;

public class Update extends JCheckBoxMenuItem implements ItemListener
{
    /**
     * Reference to display object.
     */
    private Disp disp_;

    /**
     * Update Dialog.
     */
    private UpdateDialog dialog_;

    /**
     * Constructor
     */
    public Update (Disp disp, JMenu menu)
    {
	super ("Update", false);
	setMnemonic(KeyEvent.VK_U);
	
	disp_ = disp;

	addItemListener (this);

	menu.add (this);

	// create update dialog
	dialog_ = new UpdateDialog (disp, this);
    }

    /**
     * Implmentation of actionPerformed when Update button is pressed.
     */
    public void itemStateChanged(ItemEvent e)  
    {
	if (getState() == true) {
	    dialog_.pack ();
	    dialog_.setLocationRelativeTo (disp_.getParentWindow());
	    // I have to use setVisiable instead of show to make sure
	    // dialog box is poped up on top of table widget.
	    dialog_.setVisible (true);
	}
	else {
	    if (disp_.getType () == Disp.UPDATING)
		disp_.stopUpdating ();
	}
    }
}









