/**************************************************************************
 * Copyright (c)   2001    Southeastern Universities Research Association,
 *                         Thomas Jefferson National Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
 **************************************************************************
 *
 * Description:
 *      Query Progress Dialog Box
 *
 * Author:  
 *      Jie Chen
 *      Jefferson Lab HPC Group
 *
 * Revision History:
 *   $Log: QueryProgDialog.java,v $
 *   Revision 1.1  2001/10/18 18:45:42  chen
 *   First version of Jcmlog
 *
 *
 *
 */
package cmlog.gui;

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

import cmlog.*;

public class QueryProgDialog extends JDialog implements ActionListener
{
    /**
     * Internal title 
     */
    private JLabel title_;

    /**
     * Internal OK button.
     */
    private JButton ok_;

    /**
     * Internal cancel button.
     */
    private JButton cancel_;

    /**
     * Help button.
     */
    private JButton help_;

    /**
     * Text input field for selection message
     */
    private JTextField input_;

    /**
     * Check box for all message
     */
    private JCheckBox  allmsg_;

    /**
     * Scale to select how many messages.
     */
    private JSlider    num_;

    /**
     * Display associated with this dialog.
     */
    private Disp disp_;

    /**
     * Query argument object.
     */
    private QueryArgument qarg_ = null;


    /**
     * Dialog box for generating selection message.
     */
    private SelectionMsgDialog smsgDialog_ = null;

    /**
     * Create searching message input panel.
     */
    private JPanel createInputPanel ()
    {
	JPanel panel = new JPanel ();
	Box    box  = Box.createHorizontalBox ();

	input_ = new JTextField (40);
	input_.setEditable (false);
	box.add (input_, BorderLayout.CENTER);
	
	Component tmp = box.createHorizontalGlue ();
	box.add (tmp);

	help_ = new JButton ("Help...");
	help_.addActionListener (this);
	box.add (help_);

	panel.add (box);
	return panel;
    }

    /**
     * Create button panel
     */
    private JPanel createButtonPanel ()
    {
	// grid layout 1 row 2 column, 40 hgap, 0 vgap
	GridLayout bl = new GridLayout (1, 2, 40, 0);
	JPanel panel = new JPanel (bl);

	// create ok button
	ok_ = new JButton ("Yes");
	panel.add (ok_);

	// create cancel button 
	cancel_ = new JButton ("No");
	panel.add (cancel_);

	// add action listener
	ok_.addActionListener (this);
	cancel_.addActionListener (this);

	return panel;
    }


    /**
     * Constructor.
     */
    public QueryProgDialog (Disp disp)
    {
	super (disp.getParentWindow(),
	       "CMLOG Query Progress Dialog", false);

	disp_ = disp;

	// create top panel
	JPanel manager = new JPanel ();
	manager.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
	manager.setLayout(new BorderLayout(10, 10));	

	// create a vertical box
	Box vbox = Box.createVerticalBox();
	
	// create top label
	title_ = new JLabel("Found 100 items, do you want to continue?");
	title_.setAlignmentX(Component.CENTER_ALIGNMENT);
	vbox.add (title_);

	Component tmp = Box.createVerticalStrut (10);
	vbox.add (tmp);

	JPanel inputpanel = createInputPanel ();
	inputpanel.setBorder (BorderFactory.createTitledBorder("Server searching message"));
	vbox.add (inputpanel);

	// create sep
	tmp = Box.createVerticalStrut (10);
	vbox.add (tmp);

	// create check box
	allmsg_ = new JCheckBox ("Get all messages");
	allmsg_.setAlignmentX(Component.CENTER_ALIGNMENT);
	vbox.add (allmsg_);

	// create scale
	num_ = new JSlider (100, 2100, 200);
	num_.setMajorTickSpacing(500);
	num_.setMinorTickSpacing(100);
	num_.setPaintTicks (true);
	num_.setPaintLabels (true);
	num_.setBorder (BorderFactory.createTitledBorder("Number of messages to search"));
	vbox.add (num_);

	manager.add (vbox, BorderLayout.CENTER);

	// create button panel
	JPanel buttonpanel = createButtonPanel ();
	manager.add (buttonpanel, BorderLayout.SOUTH);

	// put panel into content pane
	Container cpn = getContentPane ();
	cpn.add (manager);

	getRootPane().setDefaultButton(ok_);

	// create selection dialog box
	smsgDialog_ = new SelectionMsgDialog (disp_, input_);
    }

    /**
     * Action listener
     */
    public void actionPerformed (ActionEvent e)
    {
	Object source = e.getSource ();

	if (source == help_) {
	    smsgDialog_.pack ();
	    smsgDialog_.setLocationRelativeTo (disp_.getTable());
	    // I have to use setVisiable instead of show to make sure
	    // dialog box is poped up on top of table widget.
	    smsgDialog_.setVisible (true);
	}
	else if (source == ok_) {
	    // number of messages to select
	    int numitems = num_.getValue();
	    
	    // do we try to get everything
	    boolean getall = allmsg_.isSelected();

	    // get query string
	    String qstr = input_.getText ();
	    if (qstr != null) {
		qstr = qstr.trim ();
		if (qstr.length() == 0)
		    qstr = null;
	    }
	    
	    // now ask display to do query
	    disp_.doQuery (qarg_.from, qarg_.to, 
			   numitems, getall, qstr, false);
	    
	    // hide this dialog
	    hide ();
	}
	else
	    hide ();
    }

    /**
     * Update this dialog with query information.
     */
    public void updateQueryInfo (String title,
				 double startTime,
				 QueryArgument qarg)
    {
	// get query argument
	qarg_ = qarg;

	// set new title
	title_.setText (title);
	
	// reset from time for the query argument
	Date from = new Date ();
	// add 100 milli second skew
	from.setTime ((long)startTime*1000 + 100);

	qarg_.from = from;

	// set UI to reflect this query argument
	if (qarg_.getall == true)
	    allmsg_.setSelected (true);
	else
	    allmsg_.setSelected (false);

	if (qarg_.qmsg != null)
	    input_.setText (qarg_.qmsg);

	num_.setValue (qarg_.num);
    }
}


    








