/**************************************************************************
 * Copyright (c)   2001    Southeastern Universities Research Association,
 *                         Thomas Jefferson National Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
 **************************************************************************
 *
 * Description:
 *      Exit menu button inside File Menu
 *
 * Author:  
 *      Jie Chen
 *      Jefferson Lab HPC Group
 *
 * Revision History:
 *   $Log: Exit.java,v $
 *   Revision 1.1  2001/10/18 18:45:41  chen
 *   First version of Jcmlog
 *
 *
 *
 */
package cmlog.gui;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

import cmlog.*;

public class Exit extends JMenuItem implements ActionListener
{
    /**
     * Reference to display object.
     */
    private Disp disp_;

    /**
     * Constructor
     */
    public Exit (Disp disp, JMenu menu)
    {
	super ("Exit", KeyEvent.VK_Q);
	
	disp_ = disp;

	addActionListener (this);

	menu.add (this);
    }

    /**
     * Implmentation of actionPerformed when exit button is pressed.
     */
    public void actionPerformed(ActionEvent e) 
    {
	disp_.exit ();
    }
}









