/*-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog server configuration header file
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogConfig.h,v $
//   Revision 1.7  2002/12/09 18:29:26  chen
//   Port to RedHat 8
//
//   Revision 1.6  2001/07/25 14:26:35  chen
//   64 BIT Initial Port
//
//   Revision 1.5  2001/06/21 18:19:25  chen
//   Port to RedHat 7.1
//
//   Revision 1.4  2000/12/13 16:45:03  chen
//   fix warning for linux
//
//   Revision 1.3  2000/02/07 15:45:55  chen
//   change number threads to 20 and increase shared memory size
//
//   Revision 1.2  2000/01/04 14:19:53  chen
//   port to redhat 6.0
//
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.8  1998/11/19  17:29:40  chen
// Support multiple directories for database
//
// Revision 1.7  1998/10/29  18:46:53  chen
// port to redHat 5.1
//
// Revision 1.6  1998/03/20  21:08:31  chen
// change named pipe path to /tmp/cmlog
//
// Revision 1.5  1998/03/04  13:09:02  chen
// change query process back to 2
//
// Revision 1.4  1998/01/20  20:38:07  chen
// change number of query process to 3
//
// Revision 1.3  1997/12/11  18:16:21  chen
// change default thread number to 20
//
// Revision 1.2  1997/08/26  16:57:16  chen
// cmlogClientD can be delete/restart on vx
//
// Revision 1.1  1997/08/01  15:27:07  bickley
// Added cmlog to application development system.
//
//
*/
#ifndef _CMLOG_CONFIG_H
#define _CMLOG_CONFIG_H

/* CMLOG server UDP port: different site can change this               */
/* this port will be used only if the port number cannot be found      */
/* through environment variable "CMLOG_PORT"    

/* Physics division                                                    */
#define CMLOG_PORT        ((unsigned short)9900)

/* Acclerator division                                                 */
/* #define CMLOG_PORT        ((unsigned short)8900)                    */

/* Test suite                                                          */
/*#define CMLOG_PORT        ((unsigned short)5003)                     */

/* CMLOG unix/vxworks client UDP port: this port will be used to       */
/* monitor server heart beat if implemented                            */

/* physics division                                                    */
#define CMLOG_CLNT_PORT   ((unsigned short)9909)

/* Accelerator division                                                */
/* #define CMLOG_CLNT_PORT   ((unsigned short)8909)                    */

/* test suite                                                          */
/*#define CMLOG_CLNT_PORT   ((unsigned short)5009)                     */

/* Minimum number of keys on a page: site specific                     */
/* This number*average record size should be less than the page size   */
/* for optimal database performace otherwise overflow pages will be    */
/* created to slow down everything                                     */
#define CMLOG_MIN_KEY_PAGE 10

/* Database page size: different site can change this                  */
#define CMLOG_PAGE_SIZE    4096

/* Number of sockets the server can open                               */
#define CMLOG_RLIMIT_NOFILE 256

/* Maximum number of client connection                                 */
#define CMLOG_MAXCLNT_CONS 64

/* Maximum number of browser connection                                */
#define CMLOG_MAXBRSER_CONS 16            

/* server directory: if set, the server will run in this directory     */
/* all logging file and process id file + core file will be here       */
#define CMLOG_DEFAULT_DIRECTORY "/tmp"

/* cmlog server log file. if defined, all debugging message will be    */
/* stored in this file in the directory specified above                */
/*#define CMLOG_LOG_FILE          "cmlogServer.log"                   */

/* cmlog server heart beat interval in seconds                         */
#define CMLOG_HEARTBEAT_INTERVAL    10

/* cmlog socket send/resv buffer size                                  */
#define CMLOG_SOCK_BUFSIZE          65535

/* cmlog client daemon pipe name                                       */
/* %d will be replaced by host ip_addr converted to a integer          */
#ifdef __vxworks
/* primary pipe for handling cmlogmsgs                                 */
#define CMLOG_CLNT_PIPE          "/pipe/cmlog_%u"
/* secondary pipe for handling logmsgs if desired                      */
#define CMLOG_CLNT_PIPE2         "/pipe/cmlog_msg_%u"
#define CMLOG_CLNT_PIPE_NUM_MSGS  50
#define CMLOG_CLNT_PIPE_MAX_BYTES 2048
#define CMLOG_CLNT_ISR_FORMAT_STR_LEN 256
#else
#define CMLOG_CLNT_PIPE          "/tmp/cmlog/cmlog_%u"
#endif

/* cmlog data base file which must be in the full path format          */
/* do not change format                                                */
#define CMLOG_DATABASE_NAME        "/usr/local/CMLOG/file/cmlog_%s"

/* cmlog context database file which must be in the full path format   */
#define CMLOG_CXTDBASE_NAME        "/usr/local/CMLOG/file/cmlogcxt_%s"

/* cmlog secondary database directories                                */
/* do not change format                                                */
/* #define CMLOG_SECONDARY_DBASE      "/usr/local/CMLOG/file/1998/data/cmlog_%s" */

/* cmlog secondary context database directories                        */
/* do not change format                                                */
/* #define CMLOG_SECONDARY_CXTDBASE   "/usr/local/CMLOG/file/1998/cxt/cmlog_%s" */

/* cmlog tag table file which must be in the full path format          */
#define CMLOG_TAGTABLE_NAME        "/usr/local/CMLOG/file/cmlogTagTable"

/* cmlog database name change interval in minutes                      */
#define CMLOG_DBASE_CHANGE_INTERVAL 24*60

/* if use thread, number of processing threads                         */
#define CMLOG_NUM_PROC_THREADS 20

/* use thread on the server                                            */
/* build client or server flag                                         */
#if defined (_CMLOG_BUILD_SERVER) && defined (_CMLOG_USE_THREAD)
#define CMLOG_USE_THREAD                                             
#endif

/* if not using thread, shared memory id command data to other proc    */
#define CMLOG_SHMEM_ID  ((key_t) 93113L)

/* if not using thread, semaphore id for accessing first shared memory */
#define CMLOG_SEM_ID  ((key_t) 93109L)

/* if not using thread, semaphore id for waking up readers             */
#define CMLOG_SEM_ID2 ((key_t) 93103L)

/* if not using thread, semaphore id for waking up writer              */
#define CMLOG_SEM_ID3 ((key_t) 93104L)

/* if not use thread, shared memory size for data queue in kbytes     */
#define CMLOG_DSHMEM_SIZE ((int) 160)                                     

/* if not using thread, first 128 bytes in the shared memory for       */
/* database name                                                       */
#define CMLOG_DBASENAME_SIZE 128

/*  Logging Client properties                                          */
/* CMLOG maximum severity                                              */
#define CMLOG_MAX_SEVERITY 100

/* CMLOG maximum verbosity                                             */
#define CMLOG_MAX_VERBOSITY 100

/* CMLOG cached messages for throttling                                */
#define CMLOG_MAX_LIST_SIZE 100

/* CMLOG time interval during which throttling is performed            */
#define CMLOG_DELTA_TIME    2

/* CMLOG number of messages will be sent during time interval          */
#define CMLOG_DEFAULT_LIMIT 100

/* Stupid hpux 10 C++ compiler does not have volatile defined          */
#if defined(__hpux10) && defined (__cplusplus)
#define volatile
#endif

#ifndef __vxworks
#include <stdio.h>

#if __GNUC__>=3
#include <new>
#else
#include <new.h>
#endif

#include <ctype.h>
#include <signal.h>
#include <string.h>
#include <assert.h>
#include <stdarg.h>
#include <fcntl.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/resource.h>
#include <sys/wait.h>

#if !defined (__hpux) && !defined (__linux)
#include <sys/sockio.h>
#endif

#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <netdb.h>
#include <unistd.h>
#include <pwd.h>

#if defined (__linux)
#include <sys/time.h>
#include <time.h>

#if defined (CMLOG_HAS_IOVECH)
#include <iovec.h>
#else
#include <sys/uio.h>
#endif

#ifndef SIGSYS
#define SIGSYS SIGUNUSED
#endif

#define msg_accrights msg_control
#define msg_accrightslen msg_controllen
#endif

/*     64 bit definition                                                 */
#if defined (__sparcv9) || defined (__alpha)
#define CMLOG_64BIT_LONG
#endif

#else
#include "vxWorks.h"
#ifndef _ARCH_PPC
#include "arch/mc68k/regsMc68k.h"
#endif
#include "stdio.h"
#include "string.h"
#include "stdlib.h"
#include "stdarg.h"
#include "ctype.h"
#include "signal.h"
#include "fcntl.h"
#include "errno.h"
#include "time.h"
#include "sys/types.h"
#include "sys/ioctl.h"
#include "sys/socket.h"
#include "sys/times.h"
#include "sys/wait.h"
#include "sys/stat.h"
#include "in.h"
#include "ifLib.h"
#include "ioLib.h"
#include "iosLib.h"
#include "logLib.h"
#include "inetLib.h"
#include "hostLib.h"
#include "sysLib.h"
#include "ifLib.h"
#include "taskLib.h"
#include "netLib.h"
#include "sigLib.h"
#include "sockLib.h"
#include "selectLib.h"
#include "kernelLib.h"
#include "net/if.h"
#include "pipeDrv.h"
#include "logLib.h"
#include "bootLib.h"
#include "intLib.h"
#endif

#endif
