#ifndef _CMLOG_CDEV_TAGMAP_H
#define _CMLOG_CDEV_TAGMAP_H

#include <cdevData.h>


// *****************************************************************************
// * class cmlog_cdevTagMap:
// *	The purpose of the cmlog_cdevTagMap is to allow rapid translation between 
// *	the cdev tag tables that within different processes.  
// *
// *	This class provides the capability to switch back and forth from the
// *	local tag values to the remote tag values.
// *****************************************************************************
class cmlog_cdevTagMap
{
private:
	int   cnt;
	int   max;
	int * local;
	int * remote;

public:
	cmlog_cdevTagMap         ( void );

	// create a tag map from a cdevData that contains two integer array
	// one array is represented by tag value 1 as local tags, another
        // one array is represented by tag value 2 as remote tags
	cmlog_cdevTagMap         (cdevData& data);

	~cmlog_cdevTagMap         ( void );
	void updateTagMap  ( cdevData & data );
	void updateTagMap  ( char ** names, int * tags, int count );
	void swapTags      ( cdevData & data, int *inTags, int *outTags, int count);
	void localToRemote ( cdevData & data ) { if(cnt) swapTags(data, remote, local, cnt); }
	void remoteToLocal ( cdevData & data ) { if(cnt) swapTags(data, local, remote, cnt); }

	int  numberOfMismatches (void) const   {return cnt;}

	// a cdevData contains two integer array with tag value 1
	// representing local
	// and tag value 2 representing remote values
	cdevData* tagmap   (void);

	void asciiDump     ( FILE * fp = stdout );
};	
		
#endif
