//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogXuiUpdate Toggle Button in the option menu
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiUpdate.cc,v $
//   Revision 1.2  2000/06/20 19:36:45  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:24  bickley
// Added cmlog to application development system.
//
//
//
#include <cmlogXuiDisp.h>
#include <cmlogXuiMenuWin.h>
#include <cmlogXuiUpdateDialog.h>
#include "cmlogXuiUpdate.h"

cmlogXuiUpdate::cmlogXuiUpdate (const char* name, int active,
				const char* acc, const char* acc_text,
				int state,
				cmlogXuiMenuWin* menuwin,
				cmlogXuiBrowser& browser)
:cmlogXuiMenuTog (name, active, acc, acc_text, state, menuwin, browser),
 dialog_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiUpdate Class Object\n");
#endif
  // empty
}

cmlogXuiUpdate::~cmlogXuiUpdate (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiUpdate Class Object\n");
#endif
  // empty
}

void
cmlogXuiUpdate::startUpdating (char* selection)
{
  cmlogXuiDisp* disp = menuwin_->displayWindow ();

  if (disp->startUpdating (selection) == CMLOG_SUCCESS) {
    disp->enableUpdating ();

    struct timeval tv;
    time_t t0;
    gettimeofday (&tv, 0);
    t0 = (time_t)tv.tv_sec;
    menuwin_->setStartTime (t0);
    menuwin_->setEndTime (-1);

    // set up right configuration
    menuwin_->updatingConfig ();

    // set toggle button to set
    setState (1);
  }
}

void
cmlogXuiUpdate::stopUpdating (void)
{
  cmlogXuiDisp* disp = menuwin_->displayWindow ();

  disp->disableUpdating ();

  // set up the right configuration
  menuwin_->normalConfig ();

  if (disp->stopUpdating () == CMLOG_SUCCESS) {
    struct timeval tv;
    time_t t0;
    gettimeofday (&tv, 0);
    t0 = (time_t)tv.tv_sec;
    menuwin_->setEndTime (t0);
  }
}

void
cmlogXuiUpdate::doit (void)
{
  if (state () > 0) {
    if (!dialog_) {
      dialog_ = new cmlogXuiUpdateDialog (this, "monitorOnDialog",
					  "monitor on dialog",
					  browser_);
      dialog_->init ();
    }
    dialog_->popup ();
    
    setState (0);
  }
  else
    stopUpdating ();
}

void
cmlogXuiUpdate::undoit (void)
{
  // empty
}
