//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Xui Updating Buffer Size Dialog Box
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiUbufDialog.h,v $
//   Revision 1.2  2000/06/20 19:36:45  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:22  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_UBUF_DIALOG_H
#define _CMLOG_XUI_UBUF_DIALOG_H

#include <stdio.h>
#include <string.h>
#include <XcodaFormDialog.h>
#include <cmlogXuiBrowser.h>

class cmlogXuiUbuf;

class cmlogXuiUbufDialog : public XcodaFormDialog
{
public:
  // constructor and destructor
  cmlogXuiUbufDialog  (cmlogXuiUbuf* command, 
		       const char* name, const char* title,
		       cmlogXuiBrowser& browser);
  ~cmlogXuiUbufDialog (void);

  // redefine popup
  void popup (void);

  const char* className (void) const {return "cmlogXuiUbufDialog";}

protected:
  // inherited operations
  void createFormChildren (void);

  // real ok action
  void        ok (void);

  // push button callbacks
  static void okCallback    (Widget w, XtPointer data, 
			     XmAnyCallbackStruct* cbs);
  static void cancelCallback (Widget w, XtPointer data, 
			      XmAnyCallbackStruct* cbs);
  
private:
  // action buttons
  Widget ok_;
  Widget cancel_;

  // toggle button for no buffering
  Widget toggle_;
  // text field widget for logic expression
  Widget size_;

  // base command button
  cmlogXuiUbuf* ubuf_;

  // network handler
  cmlogXuiBrowser& browser_;
};
#endif
