//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogXuiTitleBar Class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiTitleBar.cc,v $
//   Revision 1.2  2000/06/20 19:36:44  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:11  bickley
// Added cmlog to application development system.
//
//
#include <XcodaErrorDialog.h>
#include "cmlogXuiDisp.h"
#include "cmlogXuiTitleBar.h"

cmlogXuiTitleBar::cmlogXuiTitleBar (Widget parent, const char* name,
				    int numcol, Dimension* colwidths,
				    char** tags, char** titles,
				    cmlogXuiBrowser& browser)
:XcodaUi (name), parent_ (parent), num_cols_ (numcol),
 browser_ (browser), disp_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("          Create cmlogXuiTitleBar Class Object\n");
#endif
  int i;
  for (i = 0; i < num_cols_; i++) {
    col_widths_[i] = colwidths[i];
    // get tags
    tags_[i] = new char[strlen (tags[i]) + 1];
    strcpy (tags_[i], tags[i]);
    // set titles
    titles_[i] = new char[strlen (titles[i]) + 1];
    strcpy (titles_[i], titles[i]);
  }
  for (i = num_cols_; i < _CMLOG_XUI_MAX_COLUMNS; i++) {
    col_widths_[i] = 0;
    tags_[i] = 0;
    titles_[i] = 0;
  }
}

cmlogXuiTitleBar::~cmlogXuiTitleBar (void)
{
#ifdef _TRACE_OBJECTS
  printf ("          Delete cmlogXuiTitleBar Class Object\n");
#endif
  int i;
  for (i = 0; i < num_cols_; i++) {
    delete []tags_[i];
    delete []titles_[i];
  }
}

void
cmlogXuiTitleBar::init (void)
{
  Arg arg[20];
  int ac = 0;

  XtSetArg (arg[ac], XmNdefaultColumns, num_cols_); ac++;
  XtSetArg (arg[ac], XmNcolumnWidth, 50); ac++;
  XtSetArg (arg[ac], XmNforceColumns, True); ac++;
  XtSetArg (arg[ac], XmNverticalList, True); ac++;
  XtSetArg (arg[ac], XmNseparatorWidth, 4); ac++;
  XtSetArg (arg[ac], XmNseparatorType, XmSHADOW_ETCHED_OUT); ac++;
  XtSetArg (arg[ac], XmNpreferredWidths, col_widths_); ac++;
  XtSetArg (arg[ac], XmNlist, titles_); ac++;
  XtSetArg (arg[ac], XmNnumberStrings, num_cols_); ac++;
  XtSetArg (arg[ac], XmNmaxSelectable, 0); ac++;
  XtSetArg (arg[ac], XmNalignment, XmALIGNMENT_CENTER); ac++;
  XtSetArg (arg[ac], XmNheight, 30); ac++;
  _w = XtCreateManagedWidget ("titleBar", multiListWidgetClass, parent_,
			      arg, ac);
  ac = 0;

  // handle moveing separator callback
  XtAddCallback (_w, XmNsepMoveCallback,
		 (XtCallbackProc)&(cmlogXuiTitleBar::sepMoveCallback),
		 (XtPointer)this);

  // handle destroy callback
  installDestroyHandler ();
}

void
cmlogXuiTitleBar::configure (int numcols, Dimension* colwidths, 
			     char** tags, char** titles)
{
  int i;

  // free old information
  for (i = 0; i < num_cols_; i++) {
    delete []tags_[i];
    delete []titles_[i];
  }
  
  num_cols_ = numcols;
  for (i = 0; i < num_cols_; i++) {
    col_widths_[i] = colwidths[i];
    // set tags
    tags_[i] = new char[strlen (tags[i]) + 1];
    strcpy (tags_[i], tags[i]);
    // set titles
    titles_[i] = new char[strlen (titles[i]) + 1];
    strcpy (titles_[i], titles[i]);
  }
  for (i = num_cols_; i < _CMLOG_XUI_MAX_COLUMNS; i++) {
    col_widths_[i] = 0;
    tags_[i] = 0;
    titles_[i] = 0;
  }

  Arg arg[10];
  int ac = 0;

  XtSetArg (arg[ac], XmNdefaultColumns, num_cols_); ac++;
  XtSetArg (arg[ac], XmNpreferredWidths, col_widths_); ac++;
  XtSetArg (arg[ac], XmNlist, titles_); ac++;
  XtSetArg (arg[ac], XmNnumberStrings, num_cols_); ac++;
  XtSetValues (_w, arg, ac);
  ac = 0;
}

void
cmlogXuiTitleBar::configure (int numcols, Dimension* colwidths)
{
  int i;

  assert (num_cols_ == numcols);

  num_cols_ = numcols;
  for (i = 0; i < num_cols_; i++) 
    col_widths_[i] = colwidths[i];
  for (i = num_cols_; i < _CMLOG_XUI_MAX_COLUMNS; i++) 
    col_widths_[i] = 0;

  Arg arg[10];
  int ac = 0;

  XtSetArg (arg[ac], XmNdefaultColumns, num_cols_); ac++;
  XtSetArg (arg[ac], XmNpreferredWidths, col_widths_); ac++;
  XtSetValues (_w, arg, ac);
  ac = 0;
  // since the preferred width pointer is not changed, refresh
  MultiListRefresh (_w);
}

void
cmlogXuiTitleBar::displayWindow (cmlogXuiDisp* disp)
{
  disp_ = disp;
}

void
cmlogXuiTitleBar::sepMoveCallback (Widget w, XtPointer data,
				   MultiListSepMoveStruct* val)
{
  cmlogXuiTitleBar* obj = (cmlogXuiTitleBar *)data;

  if (obj->disp_) 
    obj->disp_->configure (val->num, val->widths);
}

char**
cmlogXuiTitleBar::titles (void)
{
  return titles_;
}



