//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Simple Date Selector
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiTimeSel.h,v $
//   Revision 1.2  2000/06/20 19:36:44  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:07  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_TIMESEL_H
#define _CMLOG_XUI_TIMESEL_H

#include <stdio.h>
#include <string.h>
#include <XcodaUi.h>
#include <cmlogXuiDate.h>

class cmlogXuiTimeSel: public XcodaUi
{
public:
  // constructor and destructor
  cmlogXuiTimeSel  (Widget parent, const char* name);
  ~cmlogXuiTimeSel (void);

  // create all widgets
  void        init (void);

  // reset widget to display current time
  void        reset (void);
  
  // string representation: caller free memory
  char*       date (void);
  // double representation
  int         date (double& time);

protected:
  static void yearArrowUp (Widget w, XtPointer data, XmAnyCallbackStruct* cbs);
  static void yearArrowDn (Widget w, XtPointer data, XmAnyCallbackStruct* cbs);

  static void monthArrowUp (Widget w, XtPointer data,XmAnyCallbackStruct* cbs);
  static void monthArrowDn (Widget w, XtPointer data,XmAnyCallbackStruct* cbs);

  static void dayArrowUp (Widget w, XtPointer data,XmAnyCallbackStruct* cbs);
  static void dayArrowDn (Widget w, XtPointer data,XmAnyCallbackStruct* cbs);

  static void hourArrowUp (Widget w, XtPointer data,XmAnyCallbackStruct* cbs);
  static void hourArrowDn (Widget w, XtPointer data,XmAnyCallbackStruct* cbs);

  static void minArrowUp (Widget w, XtPointer data,XmAnyCallbackStruct* cbs);
  static void minArrowDn (Widget w, XtPointer data,XmAnyCallbackStruct* cbs);

  static void secArrowUp (Widget w, XtPointer data,XmAnyCallbackStruct* cbs);
  static void secArrowDn (Widget w, XtPointer data,XmAnyCallbackStruct* cbs);

  // text field input modification callback
  static void dayinput   (Widget w, XtPointer data,
			  XmAnyCallbackStruct* cbs);

  static void hourinput   (Widget w, XtPointer data,
			   XmAnyCallbackStruct* cbs);

  static void minuteinput   (Widget w, XtPointer data,
			     XmAnyCallbackStruct* cbs);

  static void secondinput   (Widget w, XtPointer data,
			     XmAnyCallbackStruct* cbs);
			  

  // update widgets using current value
  void        display (void);

  // empty white space string to set label widgets
  static      char* empty_string_;

private:
  // All widgets
  Widget parent_;
  // year widgets
  Widget ylabel_, yup_, ydn_;
  // month widgets
  Widget mlabel_, mup_, mdn_;
  // day widgets
  Widget dlabel_, dup_, ddn_;
  // hour widgets
  Widget hlabel_, hup_, hdn_;
  // minute widgets
  Widget ulabel_, uup_, udn_;
  // second widgets
  Widget slabel_, sup_, sdn_;


  // real data object
  cmlogXuiDate date_;
};
#endif
