//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Single Query Message Interface
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiSingleQMsg.h,v $
//   Revision 1.2  2000/06/20 19:36:43  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:14  chen
//   CMLOG version 2.0
//
//
//
#ifndef _CMLOG_XUI_SINGLE_QMSG_H
#define _CMLOG_XUI_SINGLE_QMSG_H

#include <stdio.h>
#include <string.h>
#include <XcodaUi.h>

class XcodaSimpleOptionMenu;
class cmlogXuiQMsgDialog;

class cmlogXuiSingleQMsg : public XcodaUi
{
public:
  // constructor and destructor
  cmlogXuiSingleQMsg  (cmlogXuiQMsgDialog* parent, Widget w,
		       const char* name, const char* title);
  ~cmlogXuiSingleQMsg (void);
  
  // return query message
  char const * queryMessage (void);

  // return whether this query msg participates
  int   active (void) const;
  
  const char* className (void) const {return "cmlogXuiQMsgDialog";}

protected:
  void        init (Widget bsae);

  // check input syntax
  void        checkSyntax (void);

  // check whether a input string is a number
  static int  isNumber (char* str);

  // callback for losing focus
  static void verifyCallback (Widget, XtPointer, XmTextVerifyCallbackStruct *);

  // callback for toggle button
  static void toggleCallback (Widget, XtPointer, XmAnyCallbackStruct *);

private:
  // tag title
  char* title_;

  // all widgets
  Widget activeToggle_;
  Widget val_;

  // options for logic operators
  XcodaSimpleOptionMenu* logic_;

  // parent dialog box
  cmlogXuiQMsgDialog* parent_;

  // query string
  char     qmsg_[256];

  // logic options
  static const char* logicOptions_[];
  static const char* logicOptionNames_[];
  static int   numOptions_;
};
#endif

  
