//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogXuiSingleQMsg
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiSingleQMsg.cc,v $
//   Revision 1.2  2000/06/20 19:36:43  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:14  chen
//   CMLOG version 2.0
//
//
//
#include "cmlogXuiQMsgDialog.h"
#include "cmlogXuiSingleQMsg.h"
#include <XcodaSimpleOptionMenu.h>
#include <Xm/ToggleBG.h>
#include <Xm/LabelG.h>
#include <Xm/TextF.h>
#include <Xm/Form.h>
#include <ctype.h>


const char* cmlogXuiSingleQMsg::logicOptions_[] = 
{"==", "!=", "like", "<", ">", "<=", ">="};

const char* cmlogXuiSingleQMsg::logicOptionNames_[] = 
{"=", "!=", "has", "<", ">", 
 "<=", ">="};

int cmlogXuiSingleQMsg::numOptions_ = 7;
  

cmlogXuiSingleQMsg::cmlogXuiSingleQMsg (cmlogXuiQMsgDialog* parent,
					Widget w, 
					const char* name,
					const char* title)
  :XcodaUi (name), parent_ (parent)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiSingleQMsg Class Object\n");
#endif
  title_ = new char[::strlen (title) + 1];
  ::strcpy (title_, title);

  // create all widgets
  init (w);
}

cmlogXuiSingleQMsg::~cmlogXuiSingleQMsg (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiSingleQMsg Class Object\n");
#endif
  delete []title_;
}

void
cmlogXuiSingleQMsg::init (Widget base)
{
  Arg arg[30];
  int ac = 0;
  XmString t;
  // create a form widget to hold everything
  _w = XtCreateWidget ("qsinglemsg", xmFormWidgetClass,
		       base, 0, 0);

  // create toggle button
  t = XmStringCreateSimple ((char *)(" "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 2); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  activeToggle_ = XtCreateManagedWidget ("activeqmsg",
					 xmToggleButtonGadgetClass,
					 _w, arg, ac);
  ac = 0;
  XmStringFree (t);
  
  t = XmStringCreateSimple (title_);
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, activeToggle_); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 2); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNrightPosition, 35); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNalignment, XmALIGNMENT_END);
  Widget titleLabel = XtCreateManagedWidget ("qmsgtitlelabel",
					     xmLabelGadgetClass, _w,
					     arg, ac);
  ac = 0;
  XmStringFree (t);

  // create logic options
  logic_ = new XcodaSimpleOptionMenu (_w, "logic", " ");
  logic_->init();

  logic_->addEntries (cmlogXuiSingleQMsg::logicOptionNames_,
		      cmlogXuiSingleQMsg::numOptions_);

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, titleLabel); ac++;
  XtSetValues (logic_->baseWidget(), arg, ac);
  ac = 0;

  // create text field widget
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 2); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, logic_->baseWidget()); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 20); ac++;
  val_ = XtCreateManagedWidget ("qmsgval", xmTextFieldWidgetClass,
				_w, arg, ac);
  ac = 0;

  // manage all child
  XtManageChild (logic_->baseWidget());
  XtManageChild (_w);

  XtAddCallback (val_, XmNlosingFocusCallback,
		 (XtCallbackProc)&(cmlogXuiSingleQMsg::verifyCallback),
		 (XtPointer)this);

  XtAddCallback (activeToggle_, XmNvalueChangedCallback,
		 (XtCallbackProc)&(cmlogXuiSingleQMsg::toggleCallback),
		 (XtPointer)this);

  // installed destroy handler
  installDestroyHandler ();
}

int
cmlogXuiSingleQMsg::active (void) const
{
  if (XmToggleButtonGadgetGetState (activeToggle_))
    return 1;
  return 0;
}

char const *
cmlogXuiSingleQMsg::queryMessage (void)
{
  int  i;

  char* valtext = XmTextFieldGetString (val_);
  if (!valtext || !*valtext)
    return 0;

  strcpy (qmsg_, title_);
  strcat (qmsg_, " ");
  
  // get current selection of options
  i = logic_->currentSelection();
  strcat(qmsg_, cmlogXuiSingleQMsg::logicOptions_[i]);
  strcat (qmsg_, " ");

  if (cmlogXuiSingleQMsg::isNumber(valtext))
    strcat(qmsg_, valtext);
  else {
    strcat (qmsg_,"'");
    strcat(qmsg_, valtext);
    strcat (qmsg_,"'");
  }

  XtFree (valtext);

  return qmsg_;
}

int
cmlogXuiSingleQMsg::isNumber (char* str)
{
  char* p = str;
  while (*p && *p != '\n') {
    if (!isdigit(*p) && *p != '.' && *p != '-') {
      return 0;
      break;
    }
    p++;
  }
  return 1;
}

void
cmlogXuiSingleQMsg::checkSyntax (void)
{
 char* text;
 char* p;
 int   i;
 int   error = 0;
  
 text = XmTextFieldGetString (val_);
 if (!text || !*text) {
   parent_->reportErrorMsg ("No value is provided for logic expression");
   return;
 }

 i = logic_->currentSelection();

 if (i > 2 && !(cmlogXuiSingleQMsg::isNumber (text))) {
   // only numeric operations are allowed
   error = 1;
 }

 if (error) 
   parent_->reportErrorMsg ("Syntax error for value field of this logic expression");
 
 XtFree (text);
}

void
cmlogXuiSingleQMsg::verifyCallback (Widget w, XtPointer data,
				    XmTextVerifyCallbackStruct *)
{
  cmlogXuiSingleQMsg* obj = (cmlogXuiSingleQMsg *)data;

  if (!obj->active())
    return;
  
  obj->checkSyntax ();

}


void
cmlogXuiSingleQMsg::toggleCallback (Widget w, XtPointer data,
				    XmAnyCallbackStruct *cbs)
{
  cmlogXuiSingleQMsg* obj = (cmlogXuiSingleQMsg *)data;
  XmToggleButtonCallbackStruct *tcbs = (XmToggleButtonCallbackStruct *)cbs;

  if (tcbs->set)
    obj->checkSyntax ();
}
