//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlog save settings file selections dialog box
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiSaveSettingsDialog.cc,v $
//   Revision 1.2  2000/06/20 19:36:43  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1  1999/09/21 20:27:57  chen
//   Add dialog box for save settings
//
//
//
#include <cmlogXuiConfig.h>
#include "cmlogXuiSaveSettings.h"
#include "cmlogXuiSaveSettingsDialog.h"
#include <Xm/TextF.h>

cmlogXuiSaveSettingsDialog::cmlogXuiSaveSettingsDialog(cmlogXuiSaveSettings* parent,
						       const char* name, 
						       const char* title)
  :XcodaFileSelDialog (parent->dialogBaseWidget(), name, title), parent_ (parent)
{
#ifdef _TRACE_OBJECTS
  printf ("                           Create cmlogXuiSaveSettingsDialog Class Object\n");
#endif
}

cmlogXuiSaveSettingsDialog::~cmlogXuiSaveSettingsDialog (void)
{
#ifdef _TRACE_OBJECTS
  printf ("                           Delete cmlogXuiSaveSettingsDialog Class Object\n");
#endif
}

void
cmlogXuiSaveSettingsDialog::popup (void)
{
  XmString dir;
  char     dirname[128];
  char     defFilename[256];
  int      savercfile = 0;
  cmlogXuiConfig* config = cmlogXuiConfig::config();

  // calling parent popup routine
  XcodaFileSelDialog::popup ();
  
  // if there is no config file, save to default rc file
  if (!config->configFilename())
    savercfile = 1;

  // if we have configuration environment and we indeed use this environment,
  // we need to save to default rc file because we do not allow individual
  // user to change global settings
  char* env = getenv (cmlogXuiConfig::configEnv_);
  if (env && config->configFilename() && 
      strcmp (env, config->configFilename()) == 0) 
    savercfile = 1;

  if (savercfile) {
    char* home = getenv ("HOME");
    if (home) {
      strncpy (dirname, home, sizeof (dirname));
      strcat (dirname, "/");

      strncpy (defFilename, home, sizeof (defFilename));
      strcat  (defFilename, "/");
      strcat  (defFilename, cmlogXuiConfig::localConfig_);
    }
    else {
      strcpy  (dirname, "/");
      strcpy  (defFilename, "/");
      strcat  (defFilename, cmlogXuiConfig::localConfig_);
    }
  }
  else {
    // use current configuration as default file
    char* lslash = strrchr (config->configFilename(), '/');
    char* p =  dirname;
    char* q = config->configFilename();
    // copy config file directory
    while (q != lslash) {
      *p = *q;
      p++; q++;
    }
    *p++ = '/';
    *p++ = '\0';

    // save default filename
    strncpy (defFilename, config->configFilename(), sizeof (defFilename));
  }
  
  // create xmstring counterpart
  dir = XmStringCreateSimple (dirname);
  // put file selection into this directory
  XmFileSelectionDoSearch (_w,  dir);

  // get file name text widget
  Widget filetext = XmFileSelectionBoxGetChild (_w, XmDIALOG_TEXT);
  // put default filename in the filename text widget
  XmTextFieldSetString (filetext, defFilename);
}

void
cmlogXuiSaveSettingsDialog::execute (void)
{
  parent_->saveSettings (selectedFileName());
}

