//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Xui Query Dialog Box
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiQueryDialog.h,v $
//   Revision 1.2  2000/06/20 19:36:42  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.2  1999/02/02  16:05:52  chen
// add query and update selection message to configuration file
//
// Revision 1.1  1997/08/01  15:31:52  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_QUERY_DIALOG_H
#define _CMLOG_XUI_QUERY_DIALOG_H

#include <stdio.h>
#include <string.h>
#include <XcodaFormDialog.h>
#include <cmlogXuiBrowser.h>

class cmlogXuiTimeSel;
class cmlogXuiQuery;
class cmlogXuiQMsgDialog;

class cmlogXuiQueryDialog : public XcodaFormDialog
{
public:
  // constructor and destructor
  cmlogXuiQueryDialog  (cmlogXuiQuery* query, 
			const char* name, const char* title,
			cmlogXuiBrowser& browser);
  ~cmlogXuiQueryDialog (void);

  // override popup
  void popup (void);

  const char* className (void) const {return "cmlogXuiQueryDialog";}

protected:
  // inherited operations
  void createFormChildren (void);

  // real ok action
  void        ok (void);

  // push button callbacks
  static void okCallback (Widget w, XtPointer data, XmAnyCallbackStruct* cbs);
  static void resetCallback (Widget w, XtPointer data, XmAnyCallbackStruct* cbs);
  static void cancelCallback (Widget w, XtPointer data, XmAnyCallbackStruct* cbs);
  // callback for query message helper
  static void queryButtonCallback (Widget w, XtPointer data, XmAnyCallbackStruct* cbs);
  
  
private:
  // time interval
  cmlogXuiTimeSel* from_;
  cmlogXuiTimeSel* to_;

  // action buttons
  Widget ok_;
  Widget reset_;
  Widget cancel_;

  // toggle button for getting all
  Widget toggle_;
  // scale widget to select block size
  Widget scale_;

  // text field widget for logic expression
  Widget logic_;

  // Query message dialog
  cmlogXuiQMsgDialog* qmsgDialog_;

  // base command button
  cmlogXuiQuery* query_;

  // network handler
  cmlogXuiBrowser& browser_;
};
#endif
