//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogXuiQueryDialog class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiQueryDialog.cc,v $
//   Revision 1.3  2000/06/20 19:36:41  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.2  1999/10/29 17:40:07  chen
//   support spaces and quotes in cmlogrc file
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.2  1999/02/02  16:05:51  chen
// add query and update selection message to configuration file
//
// Revision 1.1  1997/08/01  15:31:51  bickley
// Added cmlog to application development system.
//
//
//
#include <ctype.h>
#include <Xm/PushBG.h>
#include <Xm/LabelG.h>
#include <Xm/ToggleBG.h>
#include <Xm/Scale.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/TextF.h>
#include <cmlogXuiTimeSel.h>
#include <cmlogXuiQuery.h>
#include <cmlogXuiLogicSup.h>
#include <cmlogXuiConfig.h>
#include <cmlogXuiQMsgDialog.h>
#include "cmlogXuiQueryDialog.h"

cmlogXuiQueryDialog::cmlogXuiQueryDialog (cmlogXuiQuery* query,
					  const char* name, 
					  const char* title,
					  cmlogXuiBrowser& browser)
:XcodaFormDialog (query->dialogBaseWidget (), name, title), from_ (0), to_ (0),
 ok_ (0), reset_ (0), cancel_ (0), qmsgDialog_ (0), 
 query_ (query), browser_ (browser)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Create cmlogXuiQueryDialog Class Object\n");
#endif
  // empty
}

cmlogXuiQueryDialog::~cmlogXuiQueryDialog (void)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Delete cmlogXuiQueryDialog Class Object\n");
#endif
  // empty: from_ to_ will be destroyed by XtDestroyCallback
}

void
cmlogXuiQueryDialog::createFormChildren (void)
{
  Arg arg[20];
  int ac = 0;
  XmString t;

  // create top title
  t = XmStringCreateSimple ((char *)("Select time interval to query the server"));
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  Widget title = XtCreateManagedWidget ("query_title",
					xmLabelGadgetClass, _w,
					arg, ac);
  ac = 0;
  XmStringFree (t);


  // create action form
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;  
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  Widget act_form = XtCreateWidget ("query_act_form",
				    xmFormWidgetClass,
				    _w, arg, ac);
  ac = 0;

  t = XmStringCreateSimple ((char *)("  Ok  "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNleftPosition, 5); ac++;
  XtSetArg (arg[ac], XmNshowAsDefault, 1); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  ok_ = XtCreateManagedWidget ("query_ok", xmPushButtonGadgetClass,
			       act_form, arg, ac);
  ac = 0;
  XmStringFree (t);

  t = XmStringCreateSimple ((char *)(" Reset"));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  reset_ = XtCreateManagedWidget ("query_reset", xmPushButtonGadgetClass,
				  act_form, arg, ac);
  ac = 0;
  XmStringFree (t);
  // center this widget
  Dimension swd = 0;
  XtSetArg    (arg[ac], XmNwidth, &swd); ac++;
  XtGetValues (reset_, arg, ac); 
  ac = 0;
  XtSetArg    (arg[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg    (arg[ac], XmNleftPosition, 50); ac++;
  XtSetArg    (arg[ac], XmNleftOffset, -swd/2); ac++;
  XtSetValues (reset_, arg, ac);
  ac = 0;
  
  

  t = XmStringCreateSimple ((char *)("Cancel"));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNrightPosition, 95); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  cancel_ = XtCreateManagedWidget ("query_cancel", xmPushButtonGadgetClass,
				   act_form, arg, ac);
  ac = 0;
  XmStringFree (t);


  // create two frame widgets that hold time selectors
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, title); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNrightPosition, 45); ac++;  
  XtSetArg (arg[ac], XmNshadowType, XmSHADOW_ETCHED_IN); ac++;
  Widget from_frame = XtCreateWidget ("query_from_frame",
				      xmFrameWidgetClass, _w,
				      arg, ac);
  ac = 0;
  

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, title); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNleftPosition, 55); ac++;  
  XtSetArg (arg[ac], XmNshadowType, XmSHADOW_ETCHED_IN); ac++;
  Widget to_frame = XtCreateWidget ("query_to_frame",
				    xmFrameWidgetClass, _w,
				    arg, ac);
  ac = 0;

  // create from time selector and title
  t = XmStringCreateSimple ((char *)("From"));
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNchildType, XmFRAME_TITLE_CHILD); ac++;
  Widget from_label = XtCreateManagedWidget ("query_from_label",
					     xmLabelGadgetClass, from_frame,
					     arg, ac);
  ac = 0;
  XmStringFree (t);

  from_ = new cmlogXuiTimeSel (from_frame, "query_from_sel");
  from_->init ();

  // create to time selector and title
  t = XmStringCreateSimple ((char *)("To"));
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNchildType, XmFRAME_TITLE_CHILD); ac++;
  Widget to_label = XtCreateManagedWidget ("query_from_label",
					   xmLabelGadgetClass, to_frame,
					   arg, ac);
  ac = 0;
  XmStringFree (t);

  to_ = new cmlogXuiTimeSel (to_frame, "query_to_sel");
  to_->init ();  

  // create text widget
  t = XmStringCreateSimple ((char *)("Server searching message"));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, from_frame); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5) ;ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  Widget qlabel = XtCreateManagedWidget ("q_label", xmLabelGadgetClass,
					 _w, arg, ac);
  ac = 0;
  XmStringFree (t);

  // create a form hold text and help button
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;  
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, qlabel); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 2) ;ac++;
  Widget msg_form = XtCreateWidget ("query_msg_form",
				    xmFormWidgetClass,
				    _w, arg, ac);
  ac = 0;

  // create a push button to launch query msg dialog box
  t = XmStringCreateSimple ((char *)("Help..."));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  Widget qmsgbutton = XtCreateManagedWidget("qmsgbutton",
					    xmPushButtonGadgetClass,
					    msg_form, arg, ac);
  ac = 0;
  XmStringFree (t);
  

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;  
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNrightWidget, qmsgbutton); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  logic_ = XtCreateManagedWidget ("logic_input", xmTextFieldWidgetClass,
				  msg_form, arg, ac);
  ac = 0;

  // create scale widget
  t = XmStringCreateSimple ((char *)("Number of messages to search"));
  XtSetArg (arg[ac], XmNtitleString, t); ac++;
  XtSetArg (arg[ac], XmNminimum, 20); ac++;
  XtSetArg (arg[ac], XmNmaximum, 2000); ac++;
  XtSetArg (arg[ac], XmNvalue, 200); ac++;
  XtSetArg (arg[ac], XmNshowValue, True); ac++;
  XtSetArg (arg[ac], XmNorientation, XmHORIZONTAL); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNbottomWidget, act_form); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5) ;ac++;
  scale_ = XtCreateManagedWidget ("cmlog_query_scale",
				  xmScaleWidgetClass,
				  _w, arg, ac);
  ac = 0;
  XmStringFree (t);

  // create toggle widget
  t = XmStringCreateSimple ((char *)("Get all messages"));
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNindicatorType, XmN_OF_MANY); ac++;
  XtSetArg (arg[ac], XmNvisibleWhenOff, True); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNbottomWidget, scale_); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5) ;ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, logic_); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5) ;ac++;
  toggle_ = XtCreateManagedWidget ("cmlog_query_toggle",
				   xmToggleButtonGadgetClass,
				   _w, arg, ac);
  ac = 0;
  XmStringFree (t);

  // manage all
  XtManageChild (from_frame);
  XtManageChild (to_frame);
  XtManageChild (act_form);
  XtManageChild (msg_form);


  // set default button to ok_
  defaultButton (ok_);

  // add all callbacks
  XtAddCallback (ok_, XmNactivateCallback, 
		 (XtCallbackProc)&(cmlogXuiQueryDialog::okCallback),
		 (XtPointer)this);

  XtAddCallback (reset_, XmNactivateCallback, 
		 (XtCallbackProc)&(cmlogXuiQueryDialog::resetCallback),
		 (XtPointer)this);

  XtAddCallback (cancel_, XmNactivateCallback, 
		 (XtCallbackProc)&(cmlogXuiQueryDialog::cancelCallback),
		 (XtPointer)this);

  XtAddCallback (qmsgbutton, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiQueryDialog::queryButtonCallback),
		 (XtPointer)this);
}

void
cmlogXuiQueryDialog::popup (void)
{
  XcodaFormDialog::popup ();
  
  cmlogXuiConfig* conf = cmlogXuiConfig::config ();

  if (conf->queryMessage ())
    XmTextFieldSetString (logic_, conf->queryMessage ());
}

void
cmlogXuiQueryDialog::ok (void)
{
  double from = 0.0;
  double to = 0.0;
  int    numitems = 0;
  int    getall = 0;
  char*  tstr = 0;
  char*  p;
  char*  qstr = 0;
  int    hasqstr = 0;

  cmlogXuiConfig* config = cmlogXuiConfig::config ();

  from_->date (from);
  to_->date (to);

  if (from >= to) {
    query_->reportErrorMsg ("Specified time interval error");
    return;
  }

  // get logic exprssion
  tstr = XmTextFieldGetString (logic_);

  if (tstr && *tstr) {
    p = tstr;
    while (*p != '\0' && *p != '\n') {
      if (!isspace (*p)) {
	hasqstr = 1;
	break;
      }
      p++;
    }
    if (hasqstr) {
      qstr = cmlogXuiQueryString (tstr);
      if (qstr == 0) {
	XtFree (tstr);
	query_->reportErrorMsg ("Searching message syntax error");
	return;
      }
      else {
	// Updating configuration information about query message
	config->queryMessage (tstr);
	XtFree (tstr);
      }
    }
    else
      XtFree (tstr);
  }

  XmScaleGetValue (scale_, &numitems);
  getall = XmToggleButtonGadgetGetState (toggle_);

  popdown ();

  query_->doQuery (from, to, numitems, getall, qstr);
}


void
cmlogXuiQueryDialog::okCallback (Widget w, XtPointer data,
				 XmAnyCallbackStruct* cbs)
{
  cmlogXuiQueryDialog* obj = (cmlogXuiQueryDialog *)data;

  obj->ok ();
}

void
cmlogXuiQueryDialog::resetCallback (Widget w, XtPointer data,
				    XmAnyCallbackStruct* cbs)
{
  cmlogXuiQueryDialog* obj = (cmlogXuiQueryDialog *)data;
  
  obj->from_->reset ();
  obj->to_->reset ();
}

void
cmlogXuiQueryDialog::cancelCallback (Widget w, XtPointer data,
				     XmAnyCallbackStruct* cbs)
{
  cmlogXuiQueryDialog* obj = (cmlogXuiQueryDialog *)data;

  obj->popdown ();
}

void
cmlogXuiQueryDialog::queryButtonCallback (Widget w, XtPointer data,
					  XmAnyCallbackStruct *)
{
  cmlogXuiQueryDialog* obj = (cmlogXuiQueryDialog *)data;
  
  if (!obj->qmsgDialog_) {
    obj->qmsgDialog_ = new cmlogXuiQMsgDialog (obj->logic_,
					       "QueryMsgDialog",
					       "Query Message Helper");
    obj->qmsgDialog_->init();
    obj->qmsgDialog_->setModal ();
  }
  obj->qmsgDialog_->popup ();
}

