//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of new command menu in the file menu
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiNew.cc,v $
//   Revision 1.4  2002/09/09 17:14:01  chen
//   Ready for 2.1
//
//   Revision 1.3  2000/06/20 19:36:40  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.2  1999/10/29 17:40:07  chen
//   support spaces and quotes in cmlogrc file
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.3  1998/11/19  17:37:27  chen
// cmlog 1.1 version
//
// Revision 1.2  1997/10/01  19:20:25  chen
// change version
//
// Revision 1.1  1997/08/01  15:31:45  bickley
// Added cmlog to application development system.
//
//
//
#include <XcodaApp.h>
#include "cmlogXuiMenuWin.h"
#include "cmlogXuiTopW.h"
#include "cmlogXuiNew.h"
#include "cmlogXuiConfig.h"

cmlogXuiNew::cmlogXuiNew (const char* name, int active,
			  const char* acc, const char* acc_text,
			  cmlogXuiMenuWin* win,
			  cmlogXuiBrowser& browser)
:cmlogXuiMenuBtn (name, active, acc, acc_text, win, browser)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiNew Class Object\n");
#endif
}

cmlogXuiNew::~cmlogXuiNew (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiNew Class Object\n");
#endif
}

void
cmlogXuiNew::doit (void)
{
  char title[128];

  cmlogXuiConfig* config = cmlogXuiConfig::config ();
  if (config->configName ())
    sprintf (title, "%s     CMLOG Version 2.1", config->configName());
  else
    strcpy (title, "CMLOG Version 2.1");

  cmlogXuiBrowser* nbr = new cmlogXuiBrowser (theApplication->appContext());
  if (browser_.connected())  // this browser is connected
    nbr->setServerTcpInfo (browser_.serverHost(),
			   browser_.serverTcpPort());
    
  cmlogXuiTopW* topw = new cmlogXuiTopW (title, nbr);
  topw->initialize ();
  topw->manage ();

  if (browser_.connected()) {
    if (nbr->connect () != CMLOG_SUCCESS) 
      reportErrorMsg ("Cannot establish connection to the server for new window");
  }

}

void
cmlogXuiNew::undoit (void)
{
  // empty
}

