//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog XUI Menu Bar Toggle Command (Generic Class)
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiMenuTog.h,v $
//   Revision 1.2  2000/06/20 19:36:39  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:41  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_MENU_TOG_COMD_H
#define _CMLOG_XUI_MENU_TOG_COMD_H

#include <codaTbtnComd.h>
#include <cmlogXuiBrowser.h>

class cmlogXuiDisp;
class cmlogXuiMenuWin;

class cmlogXuiMenuTog: public codaTbtnComd 
{
public:
  virtual ~cmlogXuiMenuTog (void);

  // void set cmlogXuiDisp window pointer
  void         displayWindow (cmlogXuiDisp* disp);
  // widget for all dialogs to be based from
  const Widget   dialogBaseWidget (void);

  // reporting error message
  virtual void reportErrorMsg (const char* msg); 

  // reporting error message
  virtual void reportInfoMsg  (const char* msg); 

  virtual const char *className (void) const {return "cmlogXuiMenuTog";}

protected:
  // constructor
  cmlogXuiMenuTog (const char* name, int active,
		   const char* acc, const char* acc_text, int state,
		   cmlogXuiMenuWin* win,
		   cmlogXuiBrowser& browser);

  // real text display
  cmlogXuiDisp*   disp_;

  // network handler
  cmlogXuiBrowser& browser_;

  // menu window
  cmlogXuiMenuWin* menuwin_;
};
#endif
