//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Motif Browser Main display widget (MultiList)
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiDisp.h,v $
//   Revision 1.5  2000/12/13 16:44:14  chen
//   add action and bell
//
//   Revision 1.4  2000/06/20 19:36:37  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.3  2000/01/04 14:18:41  chen
//   improve performance for rapid incoming data
//
//   Revision 1.2  1999/11/12 17:32:06  chen
//   beta 2.0
//
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:21  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_DISP_H
#define _CMLOG_XUI_DISP_H

#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <MultiList.h>
#include <XcodaUi.h>
#include <XcodaTimer.h>
#include <cmlogXuiBrowser.h>
#include <cdevData.h>

#ifndef _CMLOG_XUI_MAX_COLUMNS
#define _CMLOG_XUI_MAX_COLUMNS 64
#endif

class cmlogXuiTitleBar;

class XcodaErrorDialog;

class cmlogXuiQueryCancelDialog;

class cmlogXuiMenuWin;

class cmlogXuiQueryProg;

class XcodaInfoDialog;

class cmlogPacket;

class cmlogXuiDisp: public XcodaUi, XcodaTimer
{
public:
  // type of display window
  enum {CMLOG_UPDATING = 1024, CMLOG_QUERY};

  // constructor and destructor
  cmlogXuiDisp     (Widget parent,   const char* name, 
		    int num_columns, Dimension* columns_widths,
		    char** tags, 
		    int    ubufsize,
		    cmlogXuiMenuWin* menuwin,
		    cmlogXuiBrowser& browser);
  ~cmlogXuiDisp    (void);

  // create widget and realize the widget
  void   init      (void);

  // configure this list
  // number of columns, column widths and tags for each column
  void   configure (int num_columns, Dimension* columns_widths,
		    char** tags);

  void   configure (int num_columns, Dimension* columns_widths);

  // insert a cmlogPacket into this list
  void   append    (cmlogPacket* packet);

  // cleanup the window
  void   cleanup   (void);

  // move the list to the bottom
  void   scrollToBottom (void);

  // return menuwindow
  cmlogXuiMenuWin* menuWindow (void) const;

  // report error message
  void   reportErrorMsg (const char* msg);

  // report info message
  void   reportInfoMsg  (const char* msg);

  // popup cancel query dialog box
  void   popupCancelQueryDialog (void);
  // popdown cancel query dialog box
  void   popdownCancelQueryDialog (void);

  // setup cmlog title bar
  void   titleBar (cmlogXuiTitleBar* titleBar);

  // return window size information
  unsigned short windowWidth (void);
  unsigned short windowHeight(void);

  // define and undefine cursor
  void defineCursor   (unsigned int cursor);
  void undefineCursor (void); 

  // return type of this window
  int    type (void) const;
  // set type of this window
  void   enableUpdating  (void);
  void   disableUpdating (void);

  // start and stop updating messages
  int    startUpdating   (char* selection);
  int    stopUpdating    (void);

  // return aux information related to how to query
  int    numberItemsToGet      (void) const;
  int    getAll                (void) const;
  void   numberItemsToGet      (int number);
  void   enableGetAll          (void);
  void   disableGetAll         (void);
  void   queryMessage          (char* msg);
  char*  queryMessage          (void) const;

  // get latest time stamp from appending data to the window
  double lastDataTimeStamp     (void) const;
  // set query end/start time
  void   setEndTime            (double end);
  double endTime               (void) const;
  void   setStartingTime       (double from);
  double startingTime          (void) const;

  // set and get number of items found so far
  int    numberItemsFound      (void) const;
  void   numberItemsFound      (int num);

  // update buffer size, passing 0 disable buffering size
  void   updatingBufSize       (int size);
  int    updatingBufSize       (void) const;
  
  // fresh the whole list
  void   refresh               (void);
  
  // remove all messages
  void   removeAllMessages     (void);

  // return how many lines in the buffer
  int    numberMessagesInBuffer (void);

  // set query in progress flag
  // flag = 1, query in progress, flag = 0, not in query mode
  void   queryInProgress       (int flag);

  // return flag of query in progress
  int    isQueryInProgress     (void) const {return queryInProg_;}  

  // doing code conversion or not
  void   enableCodeConversion  (void) {doCodeConversion_ = 1;}
  void   disableCodeConversion (void) {doCodeConversion_ = 0;}
  int    doCodeConversion (void) const {return doCodeConversion_;}

  // enable and disable blinking feature
  void   enableBlinkOn  (void);
  void   disableBlinkOn (void);
  
  // toggle display between code conversion
  void   toggleCodeConvDisp (void);

  // save current screen
  int    saveCurrentScreen (char* filename);
  // save message from 'from' to 'to'
  int    saveMessages (char* filename, int from, int to);

  // do user provided action
  void   doAction (char* action);

  // query callback
  static void queryCallback (int status, void* arg, cmlogPacket* data);

  // query and monitor on callback functions
  static void monitorDataCallback (int status, void* arg, cmlogPacket* data);

  virtual const char* className (void) const {return "cmlogXuiDisp";}

protected:
  // callback function for separator moving
  static void sepMoveCallback (Widget w, XtPointer data,
			       MultiListSepMoveStruct* val);

  // get query status information such as last time stamp
  void        getQueryMiscInfo (cmlogPacket *packet, double& key);

  // expose event handler
  static void exposeEventHandler (Widget, XtPointer,XEvent *, Boolean *);

  // list widget motion callback handler
  static void pointerMotionCallback (Widget, XtPointer, 
				     MultiListPositionStruct* pstruct);

  // attribute for incoming data
  static const char* loggingData_;

  // remove monitor callback
  int    removeMonitorCallback (char* attr, 
				cmlogBrCallback callback, void* arg);

protected:
  // inherited from XcodaTimer
  void timer_callback (void);
  // display number of messages at the same time
  void display (cmlogMsg** msgs, int num, int movetobottom = 1);

private:
  // parent widget
  Widget parent_;
  // real widget handles text input
  Widget list_;
  // Real base widget is a scrolled window

  int          num_cols_;
  Dimension    col_widths_[_CMLOG_XUI_MAX_COLUMNS];
  char*        tags_ [_CMLOG_XUI_MAX_COLUMNS];
  // current end postion of the list
  int          counter_;
  // updating buffer size: 0 means unlimited buffer size (default == 2000)
  int          updateBufsize_;

  // message buffer for incoming data from monitored data source
  cmlogMsg*    mbuffer_[CMLOG_PACKET_LIST_SIZE];
  int          num_msgs_;

  // type of this window
  int          type_;

  // if type is query window, the following specify number of items to retrieve
  // and whether to get all items from the server
  // query message
  int          numitems_;
  int          getall_;
  char*        qstr_;
  // time stamp of last data we found from the server
  double       timestamp_;
  // time stamp of the start/end of search
  double       end_;
  double       start_;
  
  // number of items found
  int          numfound_;

  // default foreground and background
  Pixel        defFg_;
  Pixel        defBg_;

  // menu window
  cmlogXuiMenuWin* menuwin_;

  // network handler
  cmlogXuiBrowser& browser_;

  // error dialog box
  XcodaErrorDialog* errDialog_;

  // title bar pointer
  cmlogXuiTitleBar* titleBar_;

  // dialog box for progress report
  cmlogXuiQueryProg* progDialog_;

  // dialog box for canceling a long query
  cmlogXuiQueryCancelDialog* cancelQueryDialog_;

  // query finished reporter
  XcodaInfoDialog*   fdialog_;

  // flag to signal whether we are in the query process or not
  int                queryInProg_;

  // flag to signle whether we are doing code conversion or not
  int                doCodeConversion_;

  // global flag that signals initial startup process
  static int         initDone_;
  // global flag that signals registration of an expose event handler 
  static int         hasExposeEvHandle_;
};
#endif


  
  
