//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Browser XUI configuration Reader
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiConfig.h,v $
//   Revision 1.6  2000/06/20 19:36:36  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.5  1999/11/12 17:32:03  chen
//   beta 2.0
//
//   Revision 1.4  1999/10/29 17:40:06  chen
//   support spaces and quotes in cmlogrc file
//
//   Revision 1.3  1999/09/21 20:27:55  chen
//   Add dialog box for save settings
//
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.2  1999/02/02  16:05:51  chen
// add query and update selection message to configuration file
//
// Revision 1.1  1997/08/01  15:31:06  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_CONFIG_H
#define _CMLOG_XUI_CONFIG_H

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <cdevData.h>

class cmlogXuiCodeConverter;

class cmlogXuiConfig
{
public:
  // destructor
  ~cmlogXuiConfig (void);

  // date type enum for historical query
  // NO_DATE: no start/end specified
  // NOW:     end at current time
  // NEGATIVE: start time is specified as a negative hours and minutes from
  //           current time
  // POSITIVE: default: explicit set start and end time
  enum cmlogXuiDateType {NO_DATE = 101, NOW, NEGATIVE, POSITIVE};
  
  // return single pointer
  static cmlogXuiConfig* config (void);

  // initialization routine
  int    init                   (int argc, char** argv);

  // operations
  int          numColumns   (void);
  Dimension*   columnWidths (void);
  char**       columnTitles (void);
  char**       columnTags   (void);

  // set and get ubuffer size
  int          updateBufsize(void);
  void         updateBufsize(int size);
  
  // set and get query message string
  char*  queryMessage (void) const;
  void   queryMessage (char *msg);

  // set and get update message string
  char*  updateSelMessage (void) const;
  void   updateSelMessage (char* msg);

  // return searching time range for historical data
  double queryStartTime (void) const {return qstart_;}
  double queryEndTime   (void) const {return qend_;}

  // convert time str to corresponding double value
  int queryStartTime (char* tstr, double* start, cmlogXuiDateType* type);
  int queryEndTime   (char* tstr, double* end, cmlogXuiDateType* type);

  // convert time value into string according to date type
  int queryTimeString (double time, cmlogXuiDateType type, char buffer,
		       int bufsize);

  // return window size information
  unsigned short windowWidth (void) {return windowWidth_;}
  unsigned short windowHeight(void) {return windowHeight_;}
  void           windowWidth (unsigned short w) {windowWidth_ = w;}
  void           windowHeight(unsigned short h) {windowHeight_ = h;}

  // change default parameters
  void         changeConfiguration (int nc, Dimension* wds,
				    char** titles, char** tags,
				    int     bufsize);

  // save configuration to a file
  int          saveConfiguration   (char* name);
  // save configuration to a default file and return config file name
  int          saveConfiguration   (char filename[], int size);

  // return matched code converters
  int codeConverter (cdevData& data, cmlogXuiCodeConverter* converters[],
		     int* size);

  // convert color string to pixel for code conversion
  void                   colorStringsToPixels (void);

  // convert title to tags, input title could be title already
  // return 0: nothing found
  // do not free return value
  char*        tagOfTitle   (char* title);

  // convert tag to titles
  char*        titleOfTag   (char* tag);

  // return auto connection flag
  int          autoConnection (void) {return doConnection_;}

  // return auto updating flag
  int          autoUpdatingMode (void) {return doUpdate_;} 

  // return auto query and updating mode
  int          autoQueryAndUpdate (void) {return histUpdate_;}

  // return whether code converstion is in effect
  int          doCodeConversion (void) {return numConverters_ > 0;}

  // return whether blink is needed
  int          blinkOn (void) const;

  // return whether we are doing query
  int          autoQueryMode (void) {return doQuery_;}

  // return configuration file information
  char*        configFilename (void) {return configFile_;}

  // return configuration name
  char*        configName (void) const {return name_;}

  // set of static functions for parsing command line options
  static       void         doConnection  (char* );
  static       void         doUpdate      (char* );
  static       void         useConfigFile (char* );
  static       void         printUsage    (char* );
  static       void         doSearchUpdate(char* );
  static       void         doQuery       (char* );

  // config file location
  static const char*        localConfig_;
  // config file environment viariable
  static const char*        configEnv_;

protected:
  // constructor
  cmlogXuiConfig  (void);

  int parseFile   (char* filename);
  // parse command line configuration
  int    parseCommandLineOption (int argc, char** argv);

  // parse selection tag in the form of tag=='value'
  int    parseSelectionTag (char* string, char tag[], int tagsize,
			    char* tagval, int tagvalsize);

  // parse query message line
  // return 1: query message only
  // return 2: query message + start time
  // return 3: query message, start time + end time
  // return -1: error
  int   parseQueryMessageLine (char* line, 
			       char qmsg[], int ql,
			       char stime[], int ls,
			       char etime[], int nls);

  // parse update message line
  // return 1: update message only
  // return -1: error
  int   parseUpdateMessageLine (char* line, 
				char umsg[], int ul);

  // parse name line
  // return 1: get configuration name
  // return -1: error
  int   parseNameLine (char* line, 
		       char name[], int nl);

  // parse code conversion line
  // return 2: get discriminator and tag
  // return -1: error
  int   parseCodeConvLine (char* line, 
			   char disc[], int dl,
			   char tag[], int tl);

private:
  static cmlogXuiConfig* config_;
  static const char*     deftitles_[];
  static const char*     deftags_[];
  static Dimension       defwidths_[];
  static int             updateBufsize_;

  // data area
  int           numcols_;
  Dimension*    colwidths_;
  char**        coltitles_;
  char**        coltags_;
  int           ubufsize_;

  // title or name of this configuration
  char*         name_;

  // default query and update message
  char*         qmsg_;
  double        qstart_, qend_;
  cmlogXuiDateType qstartType_, qendType_;
  char*         qstartStr_;
  char*         qendStr_;
  char*         umsg_;

  // top level window size
  unsigned short windowWidth_;
  unsigned short windowHeight_;

  // other configurations from command line

  // do connection to server upon startup
  int           doConnection_;
  // do automatic update upon startup
  int           doUpdate_;
  // configuration file we are using
  char*         configFile_;
  // do historical search (specified in the config file) and put
  // the browser into updating mode when searching is finished
  int           histUpdate_;
  // do a query
  int           doQuery_;

  // conversion from long to string 
  cmlogXuiCodeConverter** converters_;
  int                     numConverters_;
  int                     convBufSize_;

  // date format string
  static const char* configDateFormat_;
  // alternative date format
  static const char* configDateFormat1_;
};
#endif
