//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogXuiClock Class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiClock.cc,v $
//   Revision 1.2  2000/06/20 19:36:36  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:30:57  bickley
// Added cmlog to application development system.
//
//
//
#include <Xm/Frame.h>
#include <Xm/LabelG.h>
#include <cmlogXuiClock.h>
#include <cmlogXuiMenuWin.h>

static char* cmlog_time_temp = (char *)("  Fri Apr 11 11:18:53 1997  ");

cmlogXuiClock::cmlogXuiClock (Widget parent, const char* name,
			      cmlogXuiMenuWin* window,
			      cmlogXuiBrowser& browser)
:XcodaUi (name), parent_ (parent), window_ (window), browser_ (browser)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiClock Class Object\n");
#endif
  // empty
}

cmlogXuiClock::~cmlogXuiClock (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiClock Class Object\n");
#endif
  // empty
}

void
cmlogXuiClock::init (void)
{
  Arg arg[20];
  int ac = 0;
  XmString t;
  time_t   temp;

  XtSetArg (arg[ac], XmNshadowType, XmSHADOW_IN); ac++;
  _w = XtCreateWidget ("cmlogClock", xmFrameWidgetClass, parent_,
		       arg, ac);
  ac = 0;

  t = XmStringCreateSimple (cmlog_time_temp);
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNrecomputeSize, False); ac++;
  label_ = XtCreateManagedWidget ("cmlogClockL", xmLabelGadgetClass,
				  _w, arg, ac);
  ac = 0;
  XmStringFree (t);
  
  XtManageChild (_w);
  
  // install destroy handler
  installDestroyHandler ();
}

void
cmlogXuiClock::display (time_t t) 
{
  Arg arg[10];
  int ac = 0;

  time_t t0 = t;
  XmString temp = XmStringCreateSimple (ctime (&t0));

  XtSetArg (arg[ac], XmNlabelString, temp); ac++;
  XtSetValues (label_, arg, ac);
  ac = 0;
  XmStringFree (temp);
}

  

