// test program for cmlog database
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <cmlogDatabase.h>
#include <cpThreadManager.h>
#include <cpSynch.h>
#include <cmlogUtil.h>

static char* dbasename;

static cpMutex lock;
static cpConditionMutex readyToRead(lock);

static void* reader1 (void* arg)
{
  cdevData data;
  double value;
  cmlogKey key = 0.0;
  int      status = 0;

  lock.acquire ();
  readyToRead.wait ();

  cmlogDatabase dbase (dbasename, O_RDWR);

  if ((status = dbase.cursorInit (data, &key)) != CDEV_SUCCESS) 
    fprintf (stderr, "Thread2 cannot do init cursor status %d\n", status);
  else {
    data.get ("value", &value);
    printf ("Thread2 cursor data has value %lf and key %lf\n", value, key);
    for (int i = 1; i < 100; i++) {
      data.remove ();
      key += 1.0;
      if (dbase.cursorNext (data, &key) != CDEV_SUCCESS)
	break;
      else {
	data.get ("value", &value);
	printf ("Thread2 Cursor data has value %lf and key %lf\n", value, key);
      }
      ::sleep (1.0);
    }
  }  
  return 0;
}

static void* reader (cmlogDatabase* dbase)
{
  cdevData data;
  double value;
  cmlogKey key = 0.0;

  if (dbase->cursorInit (data, &key) != CDEV_SUCCESS) 
    fprintf (stderr, "Cannot do init cursor\n");
  else {
    data.get ("value", &value);
    printf ("Cursor data has value %lf and key %lf\n", value, key);
    for (int i = 1; i < 100; i++) {
      data.remove ();
      key += 1.0;
      if (dbase->cursorNext (data, &key) != CDEV_SUCCESS)
	break;
      else {
	data.get ("value", &value);
	printf ("Cursor data has value %lf and key %lf\n", value, key);
      }
      ::sleep (1.0);
    }
  }  
  return 0;
}

main (int argc, char **argv)
{
  if (argc != 2) {
    fprintf (stderr, "usage: %s dbasename\n", argv[0]);
    exit (1);
  }
  cmlogUtil::setTags ();

  dbasename = argv[1];

  cp_thread_t reader_th, reader_th1;

  char temp[128];
  cdevData testd[10000];
 
  cmlogDatabase dbase (argv[1], O_CREAT | O_RDWR);
  cpThreadManager manager;

  // create two threads, one thread read and the other thread writes
  // manager.spawn (CP_THREAD_FUNC (reader), (void *)&dbase, 0, &reader_th);
  // manager.spawn (CP_THREAD_FUNC (reader1), (void *)&dbase, 0, &reader_th1);

  for (int i = 0; i < 100; i++) {
    sprintf (temp, "Error Message is from somewherw nobody knows with id number %lf hahahahahahahahahahahah", i);
    testd[i].insert ("value", i*10);
    testd[i].insert ("time", 1000.0);
    testd[i].insert ("status", 1);
    testd[i].insert ("severity", 0);
    testd[i].insert ("cmlogString", temp);
    testd[i].insert ("cmlogTime", (double)(i + 100));
  }

  for (i = 0; i < 100; i++) {
    if (dbase.put (testd[i]) != CDEV_SUCCESS) {
      fprintf (stderr, "Cannot insert data to database\n");
      exit (1);
    }
    printf ("Insert data with key value %lf\n", (double)(i + 100));
    // ::sleep (1);
    if (i == 1)
      readyToRead.signal ();
  }

  /*int st = cpThread::join (reader_th);*/
  /*  int st = cpThread::join (reader_th1);
  printf ("Get out of here with status %d\n", st);*/
  dbase.close ();
}

      
