// test program for cmlog database
#include <cmlogDatabase.h>
#include <stdlib.h>
#include <sys/time.h>

main (int argc, char **argv)
{
  if (argc != 2) {
    fprintf (stderr, "usage: %s dbasename\n", argv[0]);
    exit (1);
  }
  struct timeval startTime, endTime;
  double st, et;

  char temp[128];
  cdevData testd[10000];
  cdevGlobalTagTable::tagTable ();
 
  cmlogDatabase dbase (argv[1], O_CREAT | O_RDWR);
  /*  cmlogDatabase dbase (argv[1], O_RDWR);*/

  for (int i = 0; i < 10000; i++) {
    sprintf (temp, "Error Message is from somewherw nobody knows with id number %lf hahahahahahahahahahahah", i);
    testd[i].insert ("value", i*10);
    testd[i].insert ("time", 1000.0);
    testd[i].insert ("status", 1);
    testd[i].insert ("severity", 0);
    testd[i].insert ("cmlogString", temp);
    testd[i].insert ("cmlogTime", (double)i);
  }

  ::gettimeofday (&startTime, 0);
  for (i = 0; i < 10000; i++) {
    if (dbase.put (testd[i]) != CDEV_SUCCESS) {
      fprintf (stderr, "Cannot insert data to database\n");
      exit (1);
    }
  }
  ::gettimeofday (&endTime, 0);

  st = startTime.tv_sec + startTime.tv_usec/(1000000.0);
  et =  endTime.tv_sec + endTime.tv_usec/(1000000.0);

  size_t len = 0;
  size_t numEle = 0;
  testd[999].xdrSize (&len, &numEle);
  printf ("Insert 10000 records of size %d takes %lf seconds\n",
	  len, (et - st));


  // try to insert duplicated key
  /*  for (i = 100; i < 200; i++) {
    cdevData data;
    data.insert ("value", -i);
    data.insert ("time", 1000.0);
    data.insert ("cmlogTime", (double)i);
    if (dbase.put (data) != CDEV_SUCCESS) {
      fprintf (stderr, "Cannot insert data to database\n");
      exit (1);
    }
  }
  
  // try to get data
  double key, value;
  cdevData data;

  ::gettimeofday (&startTime, 0);
  srand48 (startTime.tv_sec);
  for (int i = 0; i < 10000; i++) {
    key = (lrand48()%10000);
    data.remove ();
    if (dbase.get (data, &key) != CDEV_SUCCESS) 
      fprintf (stderr, "Cannot get data with key %lf\n", key);
    else {
      data.get ("value", &value);
      //      printf ("data has value %lf and key %lf\n", value, key);
    }
  } 
  ::gettimeofday (&endTime, 0);
  st = startTime.tv_sec + startTime.tv_usec/(1000000.0);
  et =  endTime.tv_sec + endTime.tv_usec/(1000000.0);
  printf ("Get 10000 records takes %lf seconds\n", (et - st));
  

  // try cursor method
  cmlogKey key = 0.0;
  cdevData data;
  double value;
  ::gettimeofday (&startTime, 0);
  if (dbase.cursorInit (data, &key) != CDEV_SUCCESS) 
    fprintf (stderr, "Cannot do init cursor\n");
  else {
    data.get ("value", &value);
    printf ("Cursor data has value %lf and key %lf\n", value, key);
    for (int i = 1; i < 10000; i++) {
      data.remove ();
      key += 1.0;
      if (dbase.cursorNext (data, &key) != CDEV_SUCCESS)
	break;
      else {
	data.get ("value", &value);
	//	printf ("Cursor data has value %lf and key %lf\n", value, key);
      }
    }
  } 
  ::gettimeofday (&endTime, 0);
  st = startTime.tv_sec + startTime.tv_usec/(1000000.0);
  et =  endTime.tv_sec + endTime.tv_usec/(1000000.0);
  printf ("Get 10000 records takes %lf seconds\n", (et - st));*/
  dbase.close ();
}

      
