//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Inline functions for cpToken
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cpToken.i,v $
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:30:38  bickley
// Added cmlog to application development system.
//
//
#ifndef __vxworks
INLINE int
cpToken::remove (void)
{
  errno = ENOTSUP;
  return -1;
}

INLINE int 
cpToken::tryacquire (void)
{
  struct timespec spec;
  spec.tv_sec = 0;
  spec.tv_nsec = 0;
  return this->shared_acquire (0, 0, &spec);
}

INLINE int 
cpToken::waiters (void)
{
  cpMutexGuard m (this->lock_);

  int ret = this->waiters_;
  return ret;
}

INLINE cp_thread_t 
cpToken::current_owner (void)
{
  cpMutexGuard m (this->lock_);

  return this->owner_;
}
#endif