//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
// 
// Description:
//	Simple Manager for Posix Threads
//	
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cpThreadManager.i,v $
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:30:34  bickley
// Added cmlog to application development system.
//
//

// Unique thread id.  
INLINE cp_thread_t 
cpThreadDescriptor::self (void)
{
  return this->thr_id_;
}
  
// Group ID.
INLINE int 
cpThreadDescriptor::grp_id (void)
{
  return grp_id_;
}

// Current state of the thread.
INLINE cpThreadDescriptor::Thread_State 
cpThreadDescriptor::state (void)
{
  return thr_state_;
}

INLINE void
cpThreadManager::lock (void)
{
  lock_.acquire ();
}

INLINE void
cpThreadManager::unlock (void)
{
  lock_.release ();
}

INLINE
cpTMLocker::cpTMLocker (cpThreadManager* manager)
:manager_ (manager)
{
  manager_->lock ();
}

INLINE
cpTMLocker::~cpTMLocker (void)
{
  manager_->unlock ();
}

#ifndef __vxworks
// Set the exit status.
INLINE void *
cpThreadControl::status (void *s)
{
  return this->status_ = s;
}

// Get the exit status.
INLINE void *
cpThreadControl::status (void)
{
  return this->status_;
}
#endif
