//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
// 
// Description:
//	Simple Interface to Posix Threads or VxWorks Task
//	
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cpThread.h,v $
//   Revision 1.8  2002/12/09 18:24:41  chen
//   Port to RedHat 8.x
//
//   Revision 1.7  2001/07/25 14:31:08  chen
//   64 BIT Initial Port
//
//   Revision 1.6  2001/06/21 18:19:38  chen
//   Port to RedHat 7.1
//
//   Revision 1.5  2000/06/20 19:36:20  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.4  2000/04/21 18:34:41  chen
//   Port to solaris 2.7 using 4.2 compiler
//
//   Revision 1.3  2000/01/04 14:21:35  chen
//   check PTHREAD_STACK_MIN before assign value (linux)
//
//   Revision 1.2  1999/11/12 17:34:53  chen
//   Minor change
//
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.2  1997/09/16  17:00:01  chen
// port to hpux-10 thread
//
// Revision 1.1  1997/08/01  15:30:27  bickley
// Added cmlog to application development system.
//
//
#ifndef _CP_THREAD_H
#define _CP_THREAD_H

#ifndef __vxworks

#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <signal.h>
#include <pthread.h>

#if defined(__linux)

#if __GNUC__<3
extern "C" void pthread_yield (void);
#endif

#else
extern "C" void pthread_yield (void);
#endif

#if defined(__linux)
extern "C" int pthread_mutexattr_setkind_np(pthread_mutexattr_t *attr, int kind);
#endif

typedef void* (*CP_THREAD_FUNC)(void *);
typedef void  (*CP_THREAD_CLEANUP_FUNC) (void *);
typedef pthread_t cp_thread_t;
typedef pthread_key_t cp_thread_key_t;

#define CP_THREAD_CLEANUP_PUSH pthread_cleanup_push
#define CP_THREAD_CLEANUP_POP  pthread_cleanup_pop

#if defined (solaris)
#define CP_THREAD_CANCEL_DISABLE	PTHREAD_CANCEL_DISABLE
#define CP_THREAD_CANCEL_ENABLE 	PTHREAD_CANCEL_ENABLE
#define CP_THREAD_CANCEL_DEFERRED	PTHREAD_CANCEL_DEFERRED
#define CP_THREAD_CANCEL_ASYNCHRONOUS	PTHREAD_CANCEL_ASYNCHRONOUS
#define CP_THREAD_DETACHED              PTHREAD_CREATE_DETACHED
#define CP_THREAD_SCH_FIFO              0x00020000
#define CP_THREAD_SCH_RR                0x00040000
#define CP_THREAD_SCH_DEFAULT           0x00080000
#define CP_THREAD_SYSTEM                0x00100000
#define CP_THREAD_PROCESS               0x00200000
#define CP_THREAD_SCH_INHERIT           0x00400000
#define CP_THREAD_SCH_EXPLICIT          0x00800000

#define CP_THREAD_PROCESS_PRIVATE       PTHREAD_PROCESS_PRIVATE
#define CP_THREAD_PROCESS_SHARED        PTHREAD_PROCESS_SHARED

#elif defined (__hpux)
#define CP_THREAD_CANCEL_DISABLE	CANCEL_OFF
#define CP_THREAD_CANCEL_ENABLE 	CANCEL_ON
#define CP_THREAD_CANCEL_DEFERRED	CANCEL_ON
#define CP_THREAD_CANCEL_ASYNCHRONOUS	CANCEL_OFF
#define CP_THREAD_DETACHED              0
#define CP_THREAD_SCH_FIFO              SCHED_FIFO
#define CP_THREAD_SCH_RR                SCHED_RR
#define CP_THREAD_SCH_DEFAULT           SCHED_OTHER
#define CP_THREAD_SYSTEM                0x00100000
#define CP_THREAD_PROCESS               0x00200000
#define CP_THREAD_SCH_INHERIT           PTHREAD_INHERIT_SCHED
#define CP_THREAD_SCH_EXPLICIT          PTHREAD_DEFAULT_SCHED

#define CP_THREAD_PROCESS_PRIVATE       MUTEX_FAST_NP
#define CP_THREAD_PROCESS_SHARED        MUTEX_NONRECURSIVE_NP

#define PTHREAD_STACK_MIN               0x5000

// macros to provide the same interface for hp threads
#define pthread_key_create              pthread_keycreate
#define pthread_attr_init               pthread_attr_create
#define pthread_attr_destroy            pthread_attr_delete
#define pthread_attr_setschedpolicy     pthread_attr_setsched
#define pthread_mutexattr_init          pthread_mutexattr_create
#define pthread_mutexattr_setpshared    pthread_mutexattr_setkind_np
#define pthread_mutexattr_destroy       pthread_mutexattr_delete
#define pthread_condattr_init           pthread_condattr_create
#define pthread_condattr_destroy        pthread_condattr_delete
#define pthread_mutex_init(a, b)        pthread_mutex_init(a, *(b))
#define pthread_cond_init(a, b)         pthread_cond_init(a, *(b))

#elif defined (__linux)
#define CP_THREAD_CANCEL_DISABLE	PTHREAD_CANCEL_DISABLE
#define CP_THREAD_CANCEL_ENABLE 	PTHREAD_CANCEL_ENABLE
#define CP_THREAD_CANCEL_DEFERRED	PTHREAD_CANCEL_DEFERRED
#define CP_THREAD_CANCEL_ASYNCHRONOUS	PTHREAD_CANCEL_ASYNCHRONOUS
#define CP_THREAD_DETACHED              PTHREAD_CREATE_DETACHED
#define CP_THREAD_SCH_FIFO              0x00020000
#define CP_THREAD_SCH_RR                0x00040000
#define CP_THREAD_SCH_DEFAULT           0x00080000
#define CP_THREAD_SYSTEM                0x00100000
#define CP_THREAD_PROCESS               0x00200000
#define CP_THREAD_SCH_INHERIT           PTHREAD_EXPLICIT_SCHED
#define CP_THREAD_SCH_EXPLICIT          PTHREAD_INHERIT_SCHED

/* From Redhat 6.x to Redhat 7.1 PTHREAD_MUTX_FAST_NP is changed
 * and default mutex type stays as integer number 0.
 * For Redhat 6.x PTHREAD_MUTX_FAST_NP 0
 * For Redhat 7.1 PTHREAD_MUTEX_TIMED_NP 0
 * So I just define CP_THREAD_PROCESS_PRIVATE 0
 */
#define CP_THREAD_PROCESS_PRIVATE       0
#define CP_THREAD_PROCESS_SHARED        PTHREAD_MUTEX_RECURSIVE_NP

#define pthread_mutexattr_setpshared    pthread_mutexattr_setkind_np

#ifndef PTHREAD_STACK_MIN
#define PTHREAD_STACK_MIN               0x5000
#endif

#define pthread_attr_setstacksize(attr_ptr, size) 1

#endif

struct cp_cancel_state
{
  int cancelstate;
  int canceltype;
};
#else
#include "vxWorks.h"
#include "taskLib.h"
#include "taskVarLib.h"
#include "sysLib.h"
#include "stdio.h"
#include "string.h"
#include "stdlib.h"
#include "stdarg.h"
#include "ctype.h"
#include "signal.h"
#include "fcntl.h"
#include "errno.h"
#include "time.h"
#include "sys/types.h"
#include "sys/ioctl.h"
#include "sys/socket.h"
#include "sys/times.h"
#include "semLib.h"

typedef FUNCPTR CP_THREAD_FUNC;
typedef int            cp_thread_t;
typedef void  (*CP_THREAD_CLEANUP_FUNC) (void *);

#define CP_THREAD_FP_TASK          VX_FP_TASK
#define CP_THREAD_NO_STACK_FILL    VX_NO_STACK_FILL
#define CP_THREAD_PRIVATE_ENV      VX_PRIVATE_ENV
#define CP_THREAD_UNBREAKABLE      VX_UNBREAKABLE

#endif

class cpThread
{
public:
#ifndef __vxworks
  // Spawn a new thread, which executes "func" with argument "arg".
  static int spawn (CP_THREAD_FUNC func, 
		    void *arg, 
		    long flags, 
		    cp_thread_t *t_id = 0, 
		    unsigned int priority = 0,
		    void *stack = 0, 
		    unsigned stack_size = 0);


  // Spawn N new threads, which execute <func> with argument <arg>.
  // Returns the number of threads actually spawned (if this doesn't
  // equal the number requested then something has gone wrong and
  // <errno> will explain...).
  static int spawn_n (unsigned n, 
		      CP_THREAD_FUNC func, 
		      void *arg, 
		      long flags,
		      unsigned int priority = 0,
		      void *stack = 0, 
		      unsigned stack_size = 0);


  // Spawn N new threads, which execute <func> with argument <arg>.
  // The thread_ids of successfully spawned threads will be placed
  // into the <thread_ids> buffer, which must be the same size as <n>.
  // Returns the number of threads actually spawned (if this doesn't
  // equal the number requested then something has gone wrong and
  // <errno> will explain...).
  static int spawn_n (cp_thread_t thread_ids[], 
		      unsigned n, 
		      CP_THREAD_FUNC func, 
		      void *arg, 
		      long flags, 
		      unsigned int priority = 0,
		      void *stack = 0, 
		      unsigned stack_size = 0);
#else
  // Spawn a new thread, which executes "func" with argument "arg".
  static int spawn (CP_THREAD_FUNC func, 
		    void *arg, 
		    long flags = VX_FP_TASK,
		    cp_thread_t *t_id = 0, 
		    unsigned int priority = 100,
		    void *stack = 0, 
		    unsigned stack_size = 3000);


  // Spawn N new threads, which execute <func> with argument <arg>.
  // Returns the number of threads actually spawned (if this doesn't
  // equal the number requested then something has gone wrong and
  // <errno> will explain...).
  static int spawn_n (unsigned n, 
		      CP_THREAD_FUNC func, 
		      void *arg, 
		      long flags = VX_FP_TASK,
		      unsigned int priority = 100,
		      void *stack = 0, 
		      unsigned stack_size = 3000);


  // Spawn N new threads, which execute <func> with argument <arg>.
  // The thread_ids of successfully spawned threads will be placed
  // into the <thread_ids> buffer, which must be the same size as <n>.
  // Returns the number of threads actually spawned (if this doesn't
  // equal the number requested then something has gone wrong and
  // <errno> will explain...).
  static int spawn_n (cp_thread_t thread_ids[], 
		      unsigned n, 
		      CP_THREAD_FUNC func, 
		      void *arg, 
		      long flags = VX_FP_TASK, 
		      unsigned int priority = 100,
		      void *stack = 0, 
		      unsigned stack_size = 3000);
#endif


  // Wait for one or more threads to exit.
  static int join (cp_thread_t,
		   void ** = 0);

  static int kill (cp_thread_t, int signum);
  // Send a signal to the thread.

  static void yield (void);
  // Yield the thread to another.

  static cp_thread_t self (void);
  // Return the unique ID of the thread.

  static void self (cp_thread_t& id);
  // Return the unique ID of the thread.

  static void init (cp_thread_t& id);
  // init thread id to null value

  static int  equal (cp_thread_t id0, cp_thread_t id1);
  // check whether two thread id are the same. return 1 true, return 0 false

#ifndef __vxworks
  static void exit (void *status = 0);
  // Exit the current thread and return "status".

  static int sigsetmask (int how, 
			 const sigset_t *set, 
			 sigset_t *oset = 0);
  // Change and/or examine calling thread's signal mask.

  static int keycreate (cp_thread_key_t *keyp,
			void (*destructor)(void *value));
  // Allocates a <keyp> that is used to identify data that is specific
  // to each thread in the process.  The key is global to all threads
  // in the process.

  static int setspecific (cp_thread_key_t key, 
			  void *value);
  // Bind value to the thread-specific data key, <key>, for the calling
  // thread.

  static int getspecific (cp_thread_key_t key, 
			  void **valuep);
  // Stores the current value bound to <key> for the calling thread
  // into the location pointed to by <valuep>.

  static int disablecancel (struct cp_cancel_state *old_state);
  // Disable thread cancellation.

  static int enablecancel (struct cp_cancel_state *old_state, 
			   int flag);
  // Enable thread cancellation.

  static int setcancelstate (struct cp_cancel_state &new_state,
			     struct cp_cancel_state *old_state);
  // Set the cancellation state.

  static void add_cleanup_handler (CP_THREAD_CLEANUP_FUNC, void* arg);
  static void remove_cleanup_handler (int execute);

  static void testcancel (void);
  // Test the cancel?
#else
  static void exit (int code);
  static int sigsetmask (int mask);
  // Change and/or examine calling thread's signal mask.

  // due to the global symbol table, make sure use not to use
  // pointer intialization mechanism
  static int setspecific (void *value);

  static int disablecancel (void);
  // Disable thread cancellation.

  static int enablecancel (void);

  static void add_cleanup_handler (CP_THREAD_CLEANUP_FUNC, void* arg);
  static void remove_cleanup_handler (int execute);
  // add/remove clean up handler for a task

  static int setpriority (cp_thread_t id, int pri);
  static int getpriority (cp_thread_t id, int* pri);

#endif
  
  static int cancel (cp_thread_t t_id);
  // Cancel a thread.


  virtual const char* className (void) const {return "cpThread";}

private:
  cpThread (void);
  // Ensure that we don't get instantiated.
};

#undef INLINE
#ifdef __INLINE__
#define INLINE inline
#include "cpThread.i"
#else
#define INLINE
#endif 

#endif 
