//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
// 
// Description:
//	
//	
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cpThread.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.2  1997/09/16  17:00:01  chen
// port to hpux-10 thread
//
// Revision 1.1  1997/08/01  15:30:26  bickley
// Added cmlog to application development system.
//
//
#include "cpThread.h"

#ifndef __vxworks

#if defined (solaris)
static _cleanup_t _cleanup_info;
void 
cpThread::add_cleanup_handler (CP_THREAD_CLEANUP_FUNC handler, void* args)
{
  __pthread_cleanup_push(handler, (void *)args, 
			 (caddr_t)_getfp(), &_cleanup_info);
}

void
cpThread::remove_cleanup_handler (int ex)
{
  __pthread_cleanup_pop(ex, &_cleanup_info);
}

#elif defined (__hpux)
void 
cpThread::add_cleanup_handler (CP_THREAD_CLEANUP_FUNC handler, void* args)
{
  // hp only has macro, so use CP_THREAD_CLEANUP_PUSH/POP
  // empty
}

void
cpThread::remove_cleanup_handler (int ex)
{
  // empty
}

#elif defined (__linux)
static _pthread_cleanup_buffer _cleanup_info;
void 
cpThread::add_cleanup_handler (CP_THREAD_CLEANUP_FUNC handler, void* args)
{
  _pthread_cleanup_push(&_cleanup_info, handler, (void *)args);
}

void
cpThread::remove_cleanup_handler (int ex)
{
  _pthread_cleanup_pop(&_cleanup_info, ex);
}

#endif

#endif

#if !defined (__INLINE__)
#include "cpThread.i"
#endif

