%{

/*----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//----------------------------------------------------------------------------
//
// Description:    
//   Parser cmlog logic expression
//                                                  
// Author:  Jie Chen  
//       
// Revision History:
//   $Log: cmlog_logic.y,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:30:08  bickley
// Added cmlog to application development system.
//
//                                       
//---------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <cmlogLogic.h>

#ifdef __VMS
/* VMS does not have unlink but it does have the function remove().
   Note that remove() may not be able to delete directory files . */
#define unlink(tmp) (remove((tmp)))
#endif

%}

%union {
  int    ival;
  double dval;
  char *string;
}

%token <string> TAGNAME, CSTRING
%token <dval>   DVALUE
%token EQUAL, LESS, GREATER, NOTEQUAL
%token LESSOREQUAL, GREATEROREQUAL
%token LEFTP, RIGHTP, OR, AND, LIKE, NOT, CERROR
%token <ival> IVALUE
%type <ival> logic_exp, cmlog_logic

%left OR
%left AND
%left NOT
%left EQUAL LESS GREATER NOTEQUAL LESSOREQUAL GREATEROREQUAL LIKE

%%
cmlog_logic_parse: cmlog_logic {set_final_result ($1);}

cmlog_logic: logic_exp {$$ = $1; }
      | cmlog_logic AND cmlog_logic {$$=($1)&&($3);}
      | cmlog_logic OR cmlog_logic {$$=($1)||($3);}
      | NOT cmlog_logic {$$ = !($2);}
      | LEFTP cmlog_logic RIGHTP {$$ = $2;}
      ;

logic_exp: TAGNAME EQUAL IVALUE {$$ = cdev_data_equal_int ($1, $3);
                                 free ($1);}
      | TAGNAME EQUAL DVALUE    {$$ = cdev_data_equal_dbl ($1, $3);
                                 free ($1);} 
      | TAGNAME EQUAL CSTRING    {$$ = cdev_data_equal_str ($1, $3);
                                 free ($1); free ($3);}
      | TAGNAME LESS  IVALUE    {$$ = cdev_data_less_int ($1, $3);
                                 free ($1);}
      | TAGNAME LESS  DVALUE    {$$ = cdev_data_less_dbl ($1, $3);
                                 free ($1);}
      | TAGNAME GREATER IVALUE  {$$ = cdev_data_greater_int ($1, $3);
                                 free ($1);}
      | TAGNAME GREATER DVALUE  {$$ = cdev_data_greater_dbl ($1, $3);
                                 free ($1);}
      | TAGNAME LESSOREQUAL IVALUE{$$ = cdev_data_lesseq_int ($1, $3);
                                 free ($1);}
      | TAGNAME LESSOREQUAL DVALUE{$$ = cdev_data_lesseq_dbl ($1, $3);
                                 free ($1);}
      | TAGNAME GREATEROREQUAL IVALUE{$$ = cdev_data_greatereq_int ($1, $3);
                                 free ($1);}
      | TAGNAME GREATEROREQUAL DVALUE{$$ = cdev_data_greatereq_dbl ($1, $3);
                                 free ($1);}
      | TAGNAME NOTEQUAL IVALUE{$$ = cdev_data_noequal_int ($1, $3);
                                 free ($1);}
      | TAGNAME NOTEQUAL DVALUE{$$ = cdev_data_noequal_int ($1, $3);
                                 free ($1);}
      | TAGNAME NOTEQUAL CSTRING{$$ = cdev_data_noequal_str ($1, $3);
                                 free ($1); free ($3);}
      | TAGNAME LIKE CSTRING   {$$ = cdev_data_has_str ($1, $3);
                                 free ($1); free ($3);}
      ;
%%
