//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog server processing service class
//      this class is instantiated by a single thread
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogService.h,v $
//   Revision 1.2  2001/07/03 17:24:05  chen
//   Remove some unused code
//
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:30:02  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_SERVICE_H
#define _CMLOG_SERVICE_H


#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <cmlogDataQueue.h>
#include <cmlogDatabase.h>

class cmlog_cdevMessage;
class cmlogPacket;
class cmlogDataCache;

class cmlogService
{
public:
  // constructor and destructor
  cmlogService  (void);
  cmlogService  (cmlogDataQueue* queue, cmlogDatabase* dbase,
		 cmlogDatabase* cxtdbase);
  ~cmlogService (void);

  // assign data queue pointer
  void          dataQueue (cmlogDataQueue* queue);

  // assign database pointer
  void          database  (cmlogDatabase*  dbase);

  // assign context database pointer
  void          cxtdatabase (cmlogDatabase* cxtdbase);

  // assign data cache pointer
  void          dataCache   (cmlogDataCache* cache);

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  static void* serviceThread (void* arg);
#endif

protected:
  // process single message
  void process  (void);

private:
  // data queue
  cmlogDataQueue* queue_;
  // data base handler
  cmlogDatabase*  dbase_;
  // context database pointer
  cmlogDatabase* cxtdbase_;
  // pointer for data cache
  cmlogDataCache*  cache_;
  
  // deny access to copy and assignment operator
  cmlogService (const cmlogService& service);
  cmlogService& operator = (const cmlogService& service);
};
#endif
