//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog server utilties
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogServerAux.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:29:57  bickley
// Added cmlog to application development system.
//
//
#include <cmlogUtil.h>
#include "cmlogServerAux.h"

#ifdef __hpux
#define TIOCNOTTY       _IO('t', 113)
#endif

void
cmlogServerAux::closeCtrlTTY (void)
{
  int fd = ::open ("dev/tty", O_RDWR);
  ::ioctl (fd, TIOCNOTTY, 0);
  ::close (fd);
}

void
cmlogServerAux::moveToDefaultDirectory (void)
{
  if (cmlogUtil::DEFAULT_DIRECTORY)
    ::chdir (cmlogUtil::DEFAULT_DIRECTORY);
}


void
cmlogServerAux::setUMask (void)
{
  ::umask (027);
}

void
cmlogServerAux::setProcessGrp (void)
{
  // remove server from parent process group
  setpgrp ();
}

void
cmlogServerAux::setLogFile (void)
{
  if (cmlogUtil::DEFAULT_DIRECTORY && cmlogUtil::LOG_FILE) {
    close (0);
    close (1);
    close (2);

    char fullname[128];
    sprintf (fullname, "%s/%s", cmlogUtil::DEFAULT_DIRECTORY,
	     cmlogUtil::LOG_FILE);
    int fd = creat (fullname, 0644);
    fd = open (fullname, O_RDWR); // stdin
    (void) dup (fd);              // stdout
    (void) dup (fd);              // stderr
    // turn buffer out
    setbuf (stdin, 0);
    setbuf (stdout, 0);
    setbuf (stderr, 0);
  }
}

void
cmlogServerAux::recordProcessId (void)
{
  if (cmlogUtil::DEFAULT_DIRECTORY) {
    char fullname[128];
  
    sprintf (fullname, "%s/cmlog.pid", cmlogUtil::DEFAULT_DIRECTORY);
    FILE* fd = ::fopen (fullname, "w");
    if (fd) {
      fprintf (fd, "%d", getpid ());
      fclose (fd);
    }
  }
}

void
cmlogServerAux::auxiliaryHandlers (void)
{
  // close controlling tty
  closeCtrlTTY ();
  // move server to predefined directory if necessary
  moveToDefaultDirectory ();
  // restrict file creation previlige
  setUMask ();
  // set process group
  setProcessGrp ();
  // setup log file if possible
  setLogFile ();
  // record process id
  recordProcessId ();
}






