//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Server Query Thread (Service) Manager
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogQueryManager.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
//
//
#ifndef _CMLOG_QUERY_MANAGER_H
#define _CMLOG_QUERY_MANAGER_H

#include <stdio.h>
#include <string.h>
#include <cmlogSlist.h>

class cmlogQuerySvc;

class cmlogQueryManager
{
public:
  // constructor
  cmlogQueryManager  (void);
  // destructor
  ~cmlogQueryManager (void);

  // stop a query
  int abort          (cmlog_cdevMessage* stopmsg);

  // register a query service
  void registerSvc   (cmlogQuerySvc* svc);

  // remove a query service
  void removeSvc     (cmlogQuerySvc* svc);

protected:

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  // scan all registered query svcs to see whether they are alive
  void checkQuerySvcs (void) {return;}
#else
  void checkQuerySvcs (void);
#endif

private:
  cmlogSlist         qsvcList_;
};
#endif
