//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlog server's query manager
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogQueryManager.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
//
//
#include <cmlogQuerySvc.h>
#include <cmlog_cdevMessage.h>
#include "cmlogQueryManager.h"

cmlogQueryManager::cmlogQueryManager (void)
  :qsvcList_ ()
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogQueryManager Class Object\n");
#endif
}

cmlogQueryManager::~cmlogQueryManager (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogQueryManager Class Object\n");
#endif
  // scan through all svcs to see whether any of them are alive
  // and recollect resources
  checkQuerySvcs ();  
}

void
cmlogQueryManager::registerSvc (cmlogQuerySvc* svc)
{
#ifdef _CMLOG_DEBUG
  printf ("Adding cmlogQuerySvc Thread 0x%x\n",svc);
#endif
  
  // scan through all svcs to see whether any of them are alive
  // and recollect resources
  checkQuerySvcs ();  

  qsvcList_.add ((void *)svc);
}

void
cmlogQueryManager::removeSvc (cmlogQuerySvc* svc)
{
#ifdef _CMLOG_DEBUG
  printf ("Removing cmlogQuerySvc Thread 0x%x\n",svc);
#endif
  qsvcList_.remove ((void *)svc);

  // for multi-threaded version, the svc will be deleted
  // in the spawned thread
#if !defined (CMLOG_USE_THREAD) || !defined (_REENTRANT)
  delete svc;
#endif
}

int
cmlogQueryManager::abort (cmlog_cdevMessage* msg)
{
  cmlogSlistIterator ite (qsvcList_);
  cmlogQuerySvc*     tsvc = 0;
  unsigned qid = msg->getTransIndex ();
  unsigned cbkid = msg->getForeignDataIndex ();
  int      found = 0;

  // scan through all svcs to see whether any of them are alive
  checkQuerySvcs ();
  
  for (ite.init(); !ite; ++ite) {
    tsvc = (cmlogQuerySvc *) ite ();
    if (cbkid == tsvc->callbackId ()) {
      found = 1;
      break;
    }
  }
  if (found) {
#ifdef _CMLOG_DEBUG
    printf ("Abort query svc 0x%x\n", tsvc);
#endif
    tsvc->abort ();

    return 0;
  }
  return -1;
}

#if !defined (CMLOG_USE_THREAD) || !defined (_REENTRANT)
void
cmlogQueryManager::checkQuerySvcs (void)
{
  cmlogSlistIterator ite (qsvcList_);
  cmlogQuerySvc*     tsvc = 0;
  pid_t              qpid;
  int                status;
  
  for (ite.init(); !ite; ++ite) {
    tsvc = (cmlogQuerySvc *) ite ();
    qpid = tsvc->queryProcessId ();
    // call waitpid to recollect resource, otherwise the child
    // process will become zombie process
    status = waitpid (qpid, 0, WNOHANG);
    if (status == qpid) {
      delete tsvc;

#ifdef _CMLOG_DEBUG
      printf ("Query svc 0x%x is already finished, remove it\n", tsvc);
#endif
      ite.removeCurrent ();
    }
  }
}
#endif
