//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Simple Utility to check cmlog database files to see whether
//      they are corrupted or not
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogDbaseCheck.cc,v $
//   Revision 1.1  2000/02/07 16:16:47  chen
//   add cmlogDbaseCheck Utility
//
//
//
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <cmlogConfig.h>
#include <cdevData.h>
#include <cmlogUtil.h>
#include <cmlogDatabase.h>

static int
isDirectory (char* name)
{
  struct stat buf;
  int         type;

  if (stat (name, &buf) == -1) {
    fprintf (stderr, "Cannot access name %s\n", name);
    exit (1);
  }

  if ((type = buf.st_mode & S_IFMT) == S_IFDIR)
    return 1;
  else if (type == S_IFREG)
    return 0;
  else
    return -1;
}

static int
checkFile (char* filename)
{
  if (isDirectory (filename) != 0) 
    return -1;

  double key = (double)0.0;
  char   message[1024];
  cdevData data;

  printf ("Checking file %s ... ", filename);
  fflush (stdout);

  cmlogDatabase dbase (filename, O_RDONLY);
  if (dbase.cursorInit (data, &key) != CDEV_SUCCESS) {
    if (errno == EIO) {
      printf ("Found corrupted data at very beginning\n");
      return -1;
    }
  }

  data.remove ();
  while (1) {
    if ((dbase.cursorNext (data, &key)) != CDEV_SUCCESS) {
      if (errno == EIO) {
	printf ("Found corrupted data\n");
	dbase.close ();
	return -1;
      }
      else
	break;
    }
  }
  dbase.close ();
  printf ("............. ok\n");
  return 0;
}

int main (int argc, char** argv)
{
  if (argc < 2) {
    fprintf (stderr, "Usage: %s directory or filename", argv[0]);
    exit (-1);
  }
  int type = isDirectory (argv[1]);
  if (type == 1) 
    printf ("Checking files in directory: %s\n", argv[1]);
  else if (type == 0)
    printf ("Checking single file: %s\n", argv[1]);
  else {
    printf ("Not regular file or directory: %s \n", argv[1]);
    exit (1);
  }

  cmlogUtil::setTags ();


  if (type == 1) {
    DIR* dbasedir = opendir (argv[1]); 
    if (dbasedir == 0) {
      fprintf (stderr, "Cannot open directory: %s\n", argv[1]);
      exit (1);
    }
    struct dirent *direntp = 0;
    while ( (direntp = readdir (dbasedir)) != NULL) 
      if (checkFile (direntp->d_name) != 0) 
	continue;
    closedir (dbasedir);
  }
  else 
    checkFile (argv[1]);
}
