//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog resource clean up utility
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogCleanup.cc,v $
//   Revision 1.2  2000/06/20 19:35:44  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:29:49  bickley
// Added cmlog to application development system.
//
//
#include <stdio.h>
#include <string.h>
#include <cmlogConfig.h>
#include <ace/SV_Shared_Memory.h>
#include <ace/SV_Semaphore_Complex.h>

void
cmlogCleanup (void)
{
  ACE_SV_Shared_Memory shmem;
  ACE_SV_Semaphore_Complex isEmpty;
  ACE_SV_Semaphore_Complex isFull;
  ACE_SV_Semaphore_Complex lock;

  ACE_SV_Shared_Memory cshmem;

 if (lock.open (CMLOG_SEM_ID, ACE_SV_Semaphore_Simple::OPEN) != 0)
    fprintf (stderr, "Cannot get semaphore lock\n");
  if (isEmpty.open (CMLOG_SEM_ID2, ACE_SV_Semaphore_Simple::OPEN) != 0)
    fprintf (stderr, "Cannot get semaphore token\n");
  if (isFull.open (CMLOG_SEM_ID3, ACE_SV_Semaphore_Simple::OPEN) != 0)
    fprintf (stderr, "Cannot get semaphore token\n");

  if (cshmem.open (CMLOG_SHMEM_ID, 
		   (CMLOG_DSHMEM_SIZE)*1024) != 0)
    fprintf (stderr, "Cannot open shared memory\n");

  lock.remove ();
  isEmpty.remove ();
  isFull.remove ();

  cshmem.remove ();
}





    
