//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Client Daemon User Process (Task) Handler
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogUpIO.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.2  1997/08/26  16:57:17  chen
// cmlogClientD can be delete/restart on vx
//
// Revision 1.1  1997/08/01  15:29:27  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_UP_IO_H
#define _CMLOG_UP_IO_H

#include <cmlogProtocol.h>
#include <ace/Reactor.h>
#include <cmlogMsg.h>
#include <cmlogUxToServer.h>

#ifndef __vxworks
#include <ace/FIFO_Recv.h>
#else
#include <cpSynch.h>
#endif

class cmlogUpIO : public ACE_Event_Handler
{
public:
  // constructor
  cmlogUpIO (ACE_Reactor& reactor, cmlogUxToServer& toServer);
  // destructor
  ~cmlogUpIO (void);

  // inherited operations from Event_Handler
  virtual int get_handle   (void) const;

#ifdef __vxworks
  // increment of dropped message count
  int         incDroppedMsgsCount (void);

  // return whether the pipe device is full
  int         fifoFull (void);

  // remove device from device list (vxWorks)
  void        removeDevice (void);

  // disable or enable logging
  void        disableLog      (void) {dolog_ = 0;}
  void        enableLog       (void) {dolog_ = 1;}
#endif

protected:
  // inherited operations from Event_Handler
  virtual int handle_close (int, ACE_Reactor_Mask);
  virtual int handle_input (int);

private:
  // reactor
  ACE_Reactor&         reactor_;
  // TCP stream to server
  cmlogUxToServer&     toServer_;
#ifndef __vxworks
  // FIFO to user process
  ACE_FIFO_Recv        fifo_;
#else
  int                  fifo_;
  int                  dropped_;
  int                  dolog_;
#endif
};

#ifdef __vxworks
extern char*     cmlogFifoFdSymVx_;
extern "C" int   cmlogVxFifoFd (void);
extern "C" int   cmlogVxIncDroppedMsgsCount (void);
extern "C" int   cmlogVxFifoFull (void);
extern "C" void  cmlogVxLogDisable (void);
extern "C" void  cmlogVxLogEnable  (void);
#endif /* vxworks */

#endif

