//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog result notification class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogResNotification.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:29:16  bickley
// Added cmlog to application development system.
//
//
#include <cmlogMsg.h>
#include <cmlogUtil.h>
#include "cmlogResNotification.h"

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
#include <cmlogDataQueue.h>

cmlogResNotification::cmlogResNotification (void)
:ACE_Event_Handler (), queue_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogResNotification Class Object\n");
#endif
  if (cmlogResNotification::s_pipe (cfds_) < 0) {
    fprintf (stderr, "Fatal: Cannot create communication pipe\n");
    ::exit (1);
  }
}

cmlogResNotification::~cmlogResNotification (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogResNotification Class Object\n");
#endif
  // close reader of the pipe
  handle_close (-1, ACE_Event_Handler::READ_MASK);
}

cmlogResNotification::operator int* (void)
{
  return &cfds_[0];
}

int
cmlogResNotification::handle_close (int, ACE_Reactor_Mask)
{
  close (cfds_[0]);
  close (cfds_[1]);
  return 0;
}

int
cmlogResNotification::get_handle (void) const
{
  return cfds_[0];
}

int
cmlogResNotification::handle_input (int)
{
  cmlogMsg msg;

  int n = cfds_[0] >> msg;
#ifdef _CMLOG_DEBUG
  printf ("Receive %d bytes from pipe\n", n);
#endif

  if (n > 0) {
    cmlogMsg* newmsg = new cmlogMsg (msg);
    // this newmsg will be freed by dequeue method
    queue_->enqueue ((void *)newmsg);
  }
  return 0;
}

void
cmlogResNotification::dataqueue (cmlogDataQueue* queue)
{
  queue_ = queue;
}

int
cmlogResNotification::s_pipe (int* fds)
{
  if (::pipe (fds) < 0) {
    fprintf (stderr, "Cannot open a pipe 0\n");
    exit (1);
  }
  return 0;
}

#endif
