//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog query IO handler
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogQueryIO.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
//
//
#ifndef _CMLOG_QUERY_IO_H
#define _CMLOG_QUERY_IO_H

#include <cmlog_cdevMessage.h>
#include <cmlog_cdevTagMap.h>
#include <cmlogSlist.h>
#include <cmlogIO.h>
#include <cmlogMsg.h>
#include <cmlogDatabase.h>


//=====================================================================
//      tag map that maps remote tags to local tags
//      this tag map is indexed by the query id
//=====================================================================
class cmlogTagMap
{
public:
  // constructor and destructor
  cmlogTagMap   (short id);
  ~cmlogTagMap  (void);

  int           sameQuery (short id);
  cmlog_cdevTagMap&   tagmap     (void);

  // conversion operator
  operator cmlog_cdevTagMap& (void);

private:
  short         id_;
  cmlog_cdevTagMap    map_;
  
  // deny access to copy and assignment
  cmlogTagMap   (const cmlogTagMap& map);
  cmlogTagMap& operator = (const cmlogTagMap& map);
};

class cmlogQueryIO: public cmlogIO
{
public:
  // constructor and destrcutor
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cmlogQueryIO  (ACE_Reactor& r, 
		  cmlogDataQueue* dataqueue);
#else
  cmlogQueryIO  (ACE_Reactor& r, 
		  cmlogDataQueue* dataqueue, 
		  cmlogDataQueue* comdqueue);
#endif
  ~cmlogQueryIO (void);

  // write query context from this io to a database
  void        writeContextData       (cmlogDatabase& cxtdbase);

protected:
  // inherited operation for handle_input
  virtual int handle_input (int fd);

  // inherited operation for handle_close
  virtual int handle_close (int fd, ACE_Reactor_Mask);

  // reader operation: called by handle_input
  int         reader       (void);

  // set up query context
  void        setQueryContext   (cmlog_cdevMessage& data);
  // set up query context connection time id index for other data
  void        setQueryContextId (cmlog_cdevMessage& data);
  // setup tag map 
  void        setTagMap          (cmlog_cdevMessage& data);

  // utilities of clear tag and query context upon query exiting
  void        clearQueryContext (cmlog_cdevMessage& data);
  void        clearTagMap        (cmlog_cdevMessage& data);

  // update tag table to database
  void        updateTagTable     (void);

  // process incoming data with tag map
  void        processDataWithTagMap (cmlog_cdevMessage& data);

  // process cmlogPacket data
  void        processData           (cmlogPacket& packet);

  // get context data from query context
  int         getContextData         (cmlog_cdevMessage& msg, cdevData* &cxt);

private:
  // list of query connection contexts
  cmlogSlist     cxtList_;
  // list of tag map objects indexed by the query id
  cmlogSlist     tagmapList_;
  // previous context connection time
  double         prevConnTime_;
  // deny access to copy and assignment operator
  cmlogQueryIO (const cmlogQueryIO &io);
  cmlogQueryIO& operator = (const cmlogQueryIO &);
};

#endif
