//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG commonly used network utilities
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogNetUtil.h,v $
//   Revision 1.3  2001/07/25 14:30:19  chen
//   64 BIT Initial Port
//
//   Revision 1.2  2000/06/20 19:35:16  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:29:12  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_NET_UTIL_H
#define _CMLOG_NET_UTIL_H

#include <cmlogConfig.h>

#ifndef __vxworks
struct cmlog_ifnode 
{
  struct sockaddr_in brdAddr;
  struct cmlog_ifnode *next;
};
#endif

class cmlogNetUtil
{
public:
  // find server udp port to broadcast to
  static unsigned short findServerUdpPort (void);

#ifndef __vxworks
  // open local udp port
  // return 0: success, -1: failure
  static int            udpOpenLocal      (int& udp_fd);

  // send udp message to a given (host, port) to retrirve tcp port
  // return 0: success, return -1: failure
  static int            udpTalkToGivenServer (int udp_fd, 
					      unsigned short port,
					      char* host,
					      int num, unsigned opcode,
					      unsigned short& tcp_server_port);

  // broadcast message to server udp port to get server port (tcp)
  // and server host
  // return 0: success, return -1: failure
  // server_host allocated memory upon success
  static int            udpTalkToServer   (int udp_fd, unsigned short port, 
					   int num, unsigned opcode,
					   unsigned short& tcp_server_port,
					   char* & server_host);

  // connect to TCP port
  // return 0: success, return -1: failure
  static int            tcpConnect        (unsigned short port, char* host,
					   int& tcp_fd);

  // connect to TCP port with specified buffer size
  // return 0: success, return -1: failure
  static int            tcpConnect        (unsigned short port, char* host,
					   int& tcp_fd, int bufsize);

private:
  // send a udp message to a given (host, port) from local port
  // return 0: success, -1: failure
  static int            udpSendRecvWithServer (int udp_fd, char* buffer, 
					       int len, 
					       unsigned short port, 
					       char* host, int num,
					       unsigned short& server_port);
  // send message to udp port by broadcast
  // return 0: success, -1: failure
  static int            udpSendRecv       (int udp_fd, char* buffer, int len, 
					   unsigned short port, int num,
					   unsigned short& server_port,
					   char* &server_host);
  // broadcast message to a fixed port
  static int            broadcast         (int udp_fd, char* buffer, int len, 
					   unsigned short port);

  // direct udp message to a fixed port on server host
  static int            directUdpcast      (int udp_fd, char* buffer, int len, 
					   unsigned short port, char* host);

  // recv udp message from a host
  // return 0: message is received
  // return 1: no message is received
  // return -1: error
  static int            recvUdpMessage    (int udp_fd, int wait_in_sec,
					   unsigned short& tcp_server_port,
					   char* &server_host);



  // get hostname from sockaddr_in struct
  static char*   get_host_name            (struct sockaddr_in* retaddr);

  // get ifnode structure before doing broadcast
  static struct cmlog_ifnode* get_ifnode  (int fd);
#endif
};
#endif
  
