//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Generic cmlog Server to client/browser IO Handler
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogIO.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.2  1998/03/27  13:59:07  chen
// implement logServerMsg and put updatingLoggingVariable here
//
// Revision 1.1  1997/08/01  15:29:07  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_IO_H
#define _CMLOG_IO_H

#include <ace/SOCK_Stream.h>
#include <ace/INET_Addr.h>
#include <ace/Event_Handler.h>
#include <ace/Reactor.h>
#include <cdevData.h>
#include <cmlogDataQueue.h>
#include <cmlogMsg.h>

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
#include <cpSynch.h>
#endif

class cmlogAcceptor;

class cmlogIO: public ACE_Event_Handler
{
public:
  // destructor, all cmlogIOs must be deleted dynamically
  virtual ~cmlogIO (void);

  // remember connected peer address
  int   peerAddr (const ACE_INET_Addr &addr);

  // conversion operator for SOCK_Stream
  operator ACE_SOCK_Stream& (void);

  // set socket options
  int setSockOption (int level, int option, void* optval, int optlen) const;
  // send result to the connected peer
  void sendToPeer   (int command, cdevData& data, long id);

  // set acceptor pointer
  void manager (cmlogAcceptor* manager);

  // set/unset IO options
  void enable   (int signum);
  void disable  (int signum);

  // return whether the socket is still connected
  int  connected (void);
  // set connection flag
  void connectionFlag (int flag);

  // free this object
  void cleanup (void);

  // remove this object from reactor
  void deactivate (void);

  // reference couting mechanism
  void ref            (void);
  void deref          (void);

  // return socket file descriptor
  virtual int get_handle   (void) const;

  // send error status back to the browser (mt safe)
  void        sendErrorBack         (short errorcode, cmlog_cdevMessage& message);
  // send result (mt safe)
  void        sendResult            (cmlogPacket& packet);

  // log server msg to database and update interested party
  void        logServerMsg         (char* msg);

protected:
  // handle socket close 
  virtual int handle_close (int, ACE_Reactor_Mask);

  // constructor
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cmlogIO (ACE_Reactor& r, cmlogDataQueue* queue = 0);
#else
  cmlogIO (ACE_Reactor& r, cmlogDataQueue* queue = 0, 
	   cmlogDataQueue* cmdqueue = 0);
#endif

  // update logging data cache and notify all interested browser
  void        updateLoggingDataVar (cdevData& data);

  // connection to remote client
  ACE_SOCK_Stream sockStream_;
  // Reactor reference
  ACE_Reactor&    reactor_;
  // client host address
  char* clientHost_;
  // acceptor that creats this IO
  cmlogAcceptor* acceptor_;
  // data queue
  cmlogDataQueue* dataQueue_;

  // flag to signal that socket is closed
  // this flag is useful in the multi-threaded environment, since 
  // one cannot delete this object without notifying other threads
  // that are using this object
  int             connected_;

  // reference counter: this counter will track how many threads using this object
  int             refcount_;

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cpMutex         lock_;
#else
  // command queue
  cmlogDataQueue* comdQueue_;
#endif

  // friend clsss
  friend class rccAcceptor;
};
#endif
