//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG server database file handler
//
//      Database file name is changed periodically
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogDbaseHandler.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:29:04  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_DBASE_HANDLER_H
#define _CMLOG_DBASE_HANDLER_H

#include <ace/Event_Handler.h>
#include <ace/Reactor.h>
#include <ace/reactorTimer.h>
#include <cmlogDatabase.h>
#include <cmlogDataQueue.h>
#include <cmlogClientAcceptor.h>

class cmlogDbaseHandler: public reactorTimer
{
public:
  // constructor and destructor
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cmlogDbaseHandler  (ACE_Reactor& reactor, 
		      cmlogDatabase& dbase,
		      cmlogDatabase& cxtdbase,
		      cmlogClientAcceptor& clientM);
#else
  cmlogDbaseHandler  (ACE_Reactor& reactor, cmlogDataQueueWriter& queue,
		      cmlogClientAcceptor& clientM);
#endif
  ~cmlogDbaseHandler (void);

  virtual void timer_callback (void);

protected:
  // construct a database file names accoring to current time
  // return 0: success, return -1: failed
  // caller allocat large enough buffer
  static int   dbaseFileNames (char* namebuffer, char* cxtbuffer);

  // update tag table from tag table file
  // return 0: ok, return -1: no file
  int          updateTagTableFromFile (void);

  // write tags to tag table file if there is no tag table file
  // return 0: ok, return -1: not success
  int          writeToTagTableFile    (void);

private:
  // client network manager (acceptor)
  cmlogClientAcceptor& cacceptor_;
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  // real database indexed by time
  cmlogDatabase& dbase_;
  // context database indexed by connection time
  cmlogDatabase& cxtdbase_;
#else
  cmlogDataQueueWriter& queue_;
#endif
};

#endif


  
