//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog Server Client Connection Acceptor
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogClientAcceptor.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:28:53  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_CLIENT_ACCEPTOR_H
#define _CMLOG_CLIENT_ACCEPTOR_H

#include <cmlogDatabase.h>
#include <cmlogAcceptor.h>

class cmlogClientIO;

class cmlogClientAcceptor: public cmlogAcceptor
{
public:
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  // constructor and destructor
  cmlogClientAcceptor  (ACE_Reactor& r, 
			cmlogDataQueue* dataqueue);

  // dump all client connection context to a database
  void writeAllClientContext (cmlogDatabase& cxtdbase);
#else
  // constructor and destructor
  cmlogClientAcceptor  (ACE_Reactor& r, 
			cmlogDataQueue* dataqueue,
			cmlogDataQueue* cmdqueue);

  void writeAllClientContext (char* filename);
#endif
  ~cmlogClientAcceptor (void);

protected:
  // inherited operations
  virtual int handle_input (int fd);
};

#endif
