//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog Server Browser Connection Acceptor
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogBrowserAcceptor.cc,v $
//   Revision 1.2  2001/07/25 14:30:17  chen
//   64 BIT Initial Port
//
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.2  1998/03/27  13:55:59  chen
// Server insert some crucial information
//
// Revision 1.1  1997/08/01  15:28:45  bickley
// Added cmlog to application development system.
//
//
#include <cmlogUtil.h>
#include <cmlogDatabase.h>
#include "cmlogBrowserAcceptor.h"
#include "cmlogBrowserIO.h"

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
cmlogBrowserAcceptor::cmlogBrowserAcceptor (ACE_Reactor& r, 
					    cmlogDataQueue* q,
					    cmlogDatabase* dbase,
					    cmlogDatabase* cxtdbase)
:cmlogAcceptor (r, q), dbase_ (dbase), cxtdbase_ (cxtdbase)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogBrowserAcceptor Class Object\n");
#endif
}
#else
cmlogBrowserAcceptor::cmlogBrowserAcceptor (ACE_Reactor& r, 
					    cmlogDataQueue* q,
					    cmlogDataQueue* cq,
					    cmlogDatabase* dbase,
					    cmlogDatabase* cxtdbase)
:cmlogAcceptor (r, q, cq), dbase_ (dbase), cxtdbase_ (cxtdbase)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogBrowserAcceptor Class Object\n");
#endif
}
#endif

cmlogBrowserAcceptor::~cmlogBrowserAcceptor (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogBrowserAcceptor Class Object\n");
#endif
}

int
cmlogBrowserAcceptor::handle_input (int)
{
  ACE_INET_Addr    rem_addr;
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cmlogBrowserIO  *br = new cmlogBrowserIO (reactor_, dataQueue_, 
					    dbase_, cxtdbase_);
#else
  cmlogBrowserIO  *br = new cmlogBrowserIO (reactor_, dataQueue_, cmdQueue_,
					    dbase_, cxtdbase_);
#endif

  // accept the connection from a browser
  if (listener_.accept (*br, &rem_addr) != -1){
#ifdef _CMLOG_DEBUG
    printf ("Received browser connection from host %s at port %d\n",
	    rem_addr.get_host_name (), br->get_handle ());
#endif
    // check number of connections
    if (connectionList_.count () >= cmlogUtil::MAXBRSER_CONS) {
      cmlogUtil::serverPrintf ("Too many browser connections\n");
      delete br;
      return 0;
    }
    // set connected flag
    br->connectionFlag (1);
    // remeber client address
    br->peerAddr (rem_addr);
    // set socket options to KEEP_ALIVE
    int alive = 1;
    br->setSockOption (SOL_SOCKET, SO_KEEPALIVE,
		       (void *)&alive, sizeof (alive));

    // turn non block socket option off
    // which gives problem when one transfers data from hp to solaris
    br->disable (ACE_NONBLOCK);

    if (reactor_.register_handler (br,
				   ACE_Event_Handler::READ_MASK) == -1) {
#ifdef _CMLOG_DEBUG
      printf ("Unable to register cmlogBrowserIO handler\n");
#endif
      return -1;
    }
    // register this acceptor to browser IO
    br->manager (this);
    // add this client TCP connection to the list
    connectionList_.add ((void *)br);

    // log server message about browser connection
    char tmp[128];
    sprintf (tmp, "Received browser connection from host %s at port %d\n",
	     rem_addr.get_host_name (), br->get_handle ());
    br->logServerMsg (tmp);

    // log server
    cmlogUtil::serverPrintf (tmp);
  }
  else {
#ifdef _CMLOG_DEBUG
    printf ("Accept failed\n");
#endif
    return -1;
  }
  return 0;
}

