// simple test for vxWorks packet inside ISR
#include <cdevPacket1.h>
#include <cmlogMsg.h>

packetTest (void)
{
  static char sbuf[CMLOG_CLNT_PIPE_MAX_BYTES];

  cmlogVxPacket1 packet;
  int  i = 0;
  int  count = 100;
  char *facility = "coda";
  char* temp="Error Happened inside my ISR routine";

  packet.set (1234, CMLOG_ISR_DATA, 
	      "verbosity=%d severity=%d code=%d facility=%s highVIn = %d highVOut = %d text = %s", 
	      43, 12, CMLOG_ERROR, (int)facility,
	      count*2, count*100, (int)temp, 0, 0, 0); 


  size_t len = 0;
  int    wlen = 0;
  int    en;

  if (packet.streamOut (sbuf, len, CMLOG_CLNT_PIPE_MAX_BYTES) == 0) {
    printf ("vxpacket has len %d\n", len);
    d (sbuf, len/4, 4);

    cdevPacket1 pd;
   
    i = sizeof (long);
    printf ("packet size is %d\n", len-sizeof (long));
    pd.attachData (&(sbuf[i]), len - sizeof (long));

    pd.asciiDump ();

    pd.detachData ();
  }

  cdevPacket1 devp;

  devp.set (1234, 0, 0, 0, 0, CMLOG_ISR_DATA, 0, 0, "verbosity=%d severity=%d code=%d facility=%s highVIn = %d highVOut = %d text = %s", 0, 0, 0);

  char* devstr;
  size_t devlen;
  devp.streamOut (&devstr, &devlen);

  printf ("packet size is %d\n", devlen);

  d (devstr, devlen/4, 4);
}

    
