// test program for logging client inside ISR
#include <cmlogClient.h>
#include <unistd.h>
#include <wdLib.h>

#define DELAY_PERIOD 1

static WDOG_ID wdid;

char* temp="Error Happened inside my ISR routine";
char* facility = "CODA";

extern "C" int isrTest (char* name);
extern "C" int myWdShutdown (void);

static int
myWdIsr (cmlogClient* client)
{
  static int count = 0;
  int status;

  /*  status = client->postErrorI (43, 12, CMLOG_ERROR, 
			      "CODA", "highVIn = %d highVOut = %d text = %s",
			      count*2, count*100, (int)temp, 0, 0, 0);  */

  status = client->logMsgI ("verbosity=%d severity=%d code=%d facility=%s highVIn = %d highVOut = %d text = %s", 
			    43, 12, CMLOG_ERROR, (int)facility,
			    count*2, count*100, (int)temp, 0, 0, 0); 
  count++;

  //logMsg ("Inside isr count %d status %d\n", count, status, 0, 0, 0, 0);

  wdStart (wdid, sysClkRateGet () *DELAY_PERIOD, (void *)&myWdIsr, (int)client);
}

int isrTest (char* name)
{
  int status;
  cmlogClient *client = cmlogClient::logClient ();

  if (client->connect () == CMLOG_SUCCESS) {
    printf ("open to client daemon success\n");

    cdevData::insertTag (238, "myTag");
    cdevData::insertTag (322, "highVIn");
    cdevData::insertTag (323, "highVOut");
    cdevData::insertTag (324, "text");

    client->setThrottle ("highVIn", 100, 25, 1.0);


    wdid = wdCreate ();
    wdStart (wdid, DELAY_PERIOD, (void *)&myWdIsr, (int)client);

    for (;;)
      taskDelay (sysClkRateGet()*10);
  }
}


int myWdShutdown (void)
{
  int status;

  status = wdCancel (wdid);
}
