// Test program for simple browser interface
#include <cmlogBrowser.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#ifdef solaris
#include <sys/filio.h>
#endif

int ret_status = -1;

static void qcallback (int status, void* arg, cmlogPacket* data)
{
  ret_status = status;
  cdevData* res = 0;
  int i;
  printf ("status of query is %d\n", status);
  
  if (data) {
    cmlogMsg** msgs = data->messages ();
    for (i = 0; i < data->numberOfData (); i++) {
      cmlog_cdevMessage& idata = (*msgs[i]);
      res = idata.getData ();

      if (res) {
	int severity;
	char text[1024];
	char host[80];
	int hvi, hvo;

	res->get ("host", host, sizeof (host));
	res->get ("severity", &severity);
	res->get ("text", text, sizeof (text));
	res->get ("highVIn", &hvi);
	res->get ("highVOut", &hvo);

	printf ("From Host %s with Severity %d HighVIn %d HighVOut %d: %s \n",
		host, severity, hvi, hvo, text);
      }
    }
    for (i = 0; i < data->numberOfData (); i++) 
      delete msgs[i];
    delete []msgs;
  }
}

static void mcallback (int status, void* arg, cmlogPacket* data)
{
  cdevData* res = 0;
  int i;
  printf ("status of monitorOn is %d\n", status);
  
  if (data) {
    cmlogMsg** msgs = data->messages ();
    for (i = 0; i < data->numberOfData (); i++) {
      cmlog_cdevMessage& idata = (*msgs[i]);
      res = idata.getData ();
      res->asciiDump ();
    }
    for (i = 0; i < data->numberOfData (); i++) 
      delete msgs[i];
    delete []msgs;
  }
}

main (int argc, char **argv)
{
  cmlogBrowser browser;
  char         command[1024];
  char         attr[80];
  int          status;
  
  if (browser.connect () == CMLOG_SUCCESS) {
    printf ("Connected to the cmlogServer\n");

    cdevData::insertTag (4000, "myTag");
    cdevData::insertTag (4001, "highVIn");
    cdevData::insertTag (4002, "highVOut");

    while (1) {
      printf ("Enter cmlog test command\n");
      scanf ("%s", command);
      if (strcasecmp (command, "query") == 0) {
	printf ("Enter start and end time in double value\n");
	double start, end;
	scanf ("%lf %lf", &start, &end);
      
	cdevData data;
	data.insert ("start", start);
	data.insert ("end", end);

	status = browser.queryCallback (command, data, qcallback, 0);
      }
      else if (strcasecmp (command, "monitorOn") == 0) {
	printf ("Enter attribute name\n");
	scanf ("%s", attr);
	
	strcat (command, " ");
	strcat (command, attr);

	cdevData notused;
	status = browser.queryCallback (command, notused, mcallback, 0);
	
	long count = 0;
	while (1) {
	  // The count will remain 0 until, the
	  // user has pressed the carriage return
	  ioctl(fileno(stdin), FIONREAD, &count);
	  if(count > 0L) {
	    fgets(command, sizeof (command), stdin);
	    status = browser.queryCallback (command, notused, mcallback, 0);
	  }   
	  browser.pendIO (0.1);
	}
      }
      else if (strcasecmp (command, "quit") == 0)
	break;
      while (ret_status != CMLOG_SUCCESS)
	browser.pendIO (2.0);
      ret_status = -1;
    }
  }
  else
    printf ("Cannot connect to the server\n");
}
