// Test program for cmlogPacket
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <cmlogMsg.h>
#include <cpThreadManager.h>

int fd = 0;
int done = 0;
cpMutex lock;

cpConditionMutex spaceCond (lock);
cpConditionMutex fullCond (lock);
int hasSpace = 1;

void *
writer (void *arg)
{
  cmlogPacket *packet = (cmlogPacket *)arg;

  while (!done) {

    lock.acquire ();

    while (hasSpace) {
      printf ("Waiting for a full buffer to flush\n");
      fullCond.wait ();
    }

    printf ("Flush out the buffer\n");
    fd << *packet;

    packet->empty ();
    hasSpace = 1;

    printf ("Signal has space\n");
    spaceCond.signal ();
    
    lock.release ();
  }
  return 0;
}

void *
reader0 (void *arg)
{
  cmlogPacket *packet = (cmlogPacket *)arg;
  cdevData data;

  for (int i = 0; i < 100; i++) {
    data.remove ();
    data.insert ("value", i*10);
    data.insert ("time", 1000.0);
    data.insert ("status", 1);
    data.insert ("severity", 0);
    data.insert ("displayHigh", 1000);

    cmlogMsg msg (CMLOG_ADD, data);

    if (packet->overflow (msg)) {
      lock.acquire ();
      printf ("Thread 0: Packet is full at %d\n", i);
      fullCond.signal ();

      hasSpace = 0;

      if (!hasSpace) {
	printf ("Thread 0: I am waiting for space to insert\n");
	spaceCond.wait ();
      }

      printf ("Thread 0: Get space to insert\n");
      packet->insert (msg);
      lock.release ();
    }
    else 
      packet->insert (msg);
  }
  if (!packet->emptyPacket ()) {
    lock.acquire ();
    printf ("Thread 0: signal fullCond \n");
    fullCond.signal ();
    hasSpace = 0;

    lock.release ();
  }
  printf ("Thread 0: +++++++++++++++++++++++++Finished reader thread\n");
  return 0;
}  

void *
reader1 (void *arg)
{
  cmlogPacket *packet = (cmlogPacket *)arg;
  cdevData data;

  for (int i = 0; i < 100; i++) {
    data.remove ();
    data.insert ("value", i*1000);
    data.insert ("time", 1000.0);
    data.insert ("status", 1);
    data.insert ("severity", 0);
    data.insert ("displayHigh", 1000);

    cmlogMsg msg (CMLOG_ADD, data);

    if (packet->overflow (msg)) {
      lock.acquire ();
      printf ("Thread1: Packet is full at %d\n", i);
      fullCond.signal ();

      hasSpace = 0;

      if (!hasSpace) {
	printf ("Thread 1:I am waiting for space to insert\n");
	spaceCond.wait ();
      }

      printf ("Thread 1: Get space to insert\n");
      packet->insert (msg);
      lock.release ();
    }
    else 
      packet->insert (msg);
  }
  if (!packet->emptyPacket ()) {
    lock.acquire ();
    printf ("Thread 1: signal full condition\n");
    fullCond.signal ();
    lock.release ();
  }
  printf ("Thread 1:+++++++++++++++++++++++++Finished reader thread\n");
  return 0;
}  

main (int argc, char** argv)
{

  // open file for test
  fd = ::creat ("packet", 0644);
  fd = ::open ("packet", O_RDWR);
  printf ("fd is %d\n", fd);
  cmlogPacket packet;

  cdevGlobalTagTable::tagTable ();

  // create a new threads: one write to file and empty the packet
  cpThreadManager manager;
  cp_thread_t writer_t, read_t0, read_t1;

  manager.spawn (CP_THREAD_FUNC (writer), (void *)&packet, 0, &writer_t);
  manager.spawn (CP_THREAD_FUNC (reader0), (void *)&packet, 0, &read_t0);
  manager.spawn (CP_THREAD_FUNC (reader1), (void *)&packet, 0, &read_t1);

  cpThread::join (read_t0);
  cpThread::join (read_t1);
  done = 1;

  printf ("Send to writer to finish\n");

  lock.acquire ();
  fullCond.signal ();
  hasSpace = 0;
  lock.release ();

  cpThread::join (writer_t); 

  /*  while (fd >> packet != -1) {

    printf ("packet has number of data %d\n", packet.numberOfData ());
    cmlogMsg** msgs = packet.messages ();

    for (int i = 0; i < packet.numberOfData (); i++) {
      cdevData& data = (cdevData)(*msgs[i]);
      int val;

      if (data.get ("value", &val) == CDEV_SUCCESS) 
	printf ("data value for %d is %d\n", i, val);

      printf ("Msg type %d, size %d, datasize %d\n", msgs[i]->type (),
	      msgs[i]->size (), msgs[i]->dataSize ());
    }
    
    packet.empty ();
  } */
 
  close (fd); 
}

