//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
//
// Description:
//       cmlog internal server locater
//
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogSvcLocaterRep.h,v $
//   Revision 1.2  2001/07/25 14:26:38  chen
//   64 BIT Initial Port
//
//   Revision 1.1.1.1  1999/09/07 15:29:10  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:37  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_SVC_LOCATER_REP_H
#define _CMLOG_SVC_LOCATER_REP_H

#include <ace/INET_Addr.h>
#include <ace/Reactor.h>
#include <ace/SOCK_Dgram_Bcast.h>
#include <cmlogProtocol.h>

class cmlogServerLocater;

class cmlogSvcLocaterRep: public ACE_Event_Handler
{
public:
  // constructor and destructor
  cmlogSvcLocaterRep  (ACE_Reactor &r, 
		       unsigned short port, 
		       unsigned req);

  ~cmlogSvcLocaterRep (void);

  // send out braodcast request
  int sendRequest (void);
  // status of findind server
  int foundServer (void) const;

  virtual int get_handle () const;
  virtual int handle_input (int fd);
  virtual int handle_close (int fd, ACE_Reactor_Mask);

private:
  friend class           cmlogServerLocater;
  // data area
  ACE_Reactor&           reactor_;
  ACE_SOCK_Dgram_Bcast   brdcaster_;
  int                    foundServer_;
  unsigned               serverPort_;
  // port number into which send udp packet
  unsigned short         port_;
  // request protocol
  unsigned               req_;
  // try udp packet to host
  char*                  serverHost_;
};
#endif
  
